/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.dozer.converters.gtmap;

import cn.gtmap.realestate.common.core.dozer.GtmapCompareableCustomConverter;
import cn.gtmap.realestate.common.util.DateUtils;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToDateCustomConverter
implements GtmapCompareableCustomConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToDateCustomConverter.class);
    private String parameter;

    @Override
    public void setDestinationObject(Object destinationObject) {
    }

    @Override
    public void setSourceObject(Object sourceObject) {
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public Object convert(Object existingDestinationFieldValue, Object sourceFieldValue, Class<?> destinationClass, Class<?> sourceClass) {
        Date result = null;
        if (sourceFieldValue != null && sourceClass.isAssignableFrom(String.class)) {
            if (StringUtils.isNotBlank((CharSequence)this.parameter)) {
                result = DateUtils.formatDate(sourceFieldValue.toString(), this.parameter);
            } else {
                result = DateUtils.formatDate(sourceFieldValue.toString(), "yyyy-MM-dd hh:mm:ss");
                if (result == null) {
                    result = DateUtils.formatDate(sourceFieldValue.toString());
                }
            }
        }
        return result;
    }
}

