/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.dozer;

import cn.gtmap.realestate.common.core.dozer.MappingProcessor;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dozer.BeanFactory;
import org.dozer.CustomConverter;
import org.dozer.CustomFieldMapper;
import org.dozer.DozerEventListener;
import org.dozer.DozerInitializer;
import org.dozer.Mapper;
import org.dozer.MappingException;
import org.dozer.cache.CacheManager;
import org.dozer.cache.DozerCacheManager;
import org.dozer.cache.DozerCacheType;
import org.dozer.classmap.ClassMappings;
import org.dozer.classmap.Configuration;
import org.dozer.classmap.MappingFileData;
import org.dozer.config.GlobalSettings;
import org.dozer.event.DozerEventManager;
import org.dozer.factory.DestBeanCreator;
import org.dozer.loader.CustomMappingsLoader;
import org.dozer.loader.LoadMappingsResult;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.xml.MappingFileReader;
import org.dozer.loader.xml.MappingStreamReader;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.metadata.DozerMappingMetadata;
import org.dozer.metadata.MappingMetadata;
import org.dozer.stats.GlobalStatistics;
import org.dozer.stats.StatisticType;
import org.dozer.stats.StatisticsInterceptor;
import org.dozer.stats.StatisticsManager;
import org.dozer.util.MappingValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerBeanMapper
implements Mapper {
    private final Logger log = LoggerFactory.getLogger(DozerBeanMapper.class);
    private final StatisticsManager statsMgr = GlobalStatistics.getInstance().getStatsMgr();
    private final AtomicBoolean initializing = new AtomicBoolean(false);
    private final CountDownLatch ready = new CountDownLatch(1);
    private final List<String> mappingFiles = new ArrayList<String>();
    private final List<CustomConverter> customConverters = new ArrayList<CustomConverter>();
    private final List<MappingFileData> builderMappings = new ArrayList<MappingFileData>();
    private final List<DozerEventListener> eventListeners = new ArrayList<DozerEventListener>();
    private final Map<String, CustomConverter> customConvertersWithId = new HashMap<String, CustomConverter>();
    private CustomFieldMapper customFieldMapper;
    private ClassMappings customMappings;
    private Configuration globalConfiguration;
    private final CacheManager cacheManager = new DozerCacheManager();
    private DozerEventManager eventManager;

    public DozerBeanMapper() {
        this(Collections.emptyList());
    }

    public DozerBeanMapper(List<String> mappingFiles) {
        this.mappingFiles.addAll(mappingFiles);
        this.init();
    }

    public void map(Object source, Object destination, String mapId) throws MappingException {
        this.getMappingProcessor().map(source, destination, mapId);
    }

    public <T> T map(Object source, Class<T> destinationClass, String mapId) throws MappingException {
        return (T)this.getMappingProcessor().map(source, destinationClass, mapId);
    }

    public <T> T map(Object source, Class<T> destinationClass) throws MappingException {
        return (T)this.getMappingProcessor().map(source, destinationClass);
    }

    public void map(Object source, Object destination) throws MappingException {
        this.getMappingProcessor().map(source, destination);
    }

    public List<String> getMappingFiles() {
        return Collections.unmodifiableList(this.mappingFiles);
    }

    public void setMappingFiles(List<String> mappingFileUrls) {
        this.checkIfInitialized();
        this.mappingFiles.clear();
        this.mappingFiles.addAll(mappingFileUrls);
    }

    public void setFactories(Map<String, BeanFactory> factories) {
        this.checkIfInitialized();
        DestBeanCreator.setStoredFactories(factories);
    }

    public void setCustomConverters(List<CustomConverter> customConverters) {
        this.checkIfInitialized();
        this.customConverters.clear();
        this.customConverters.addAll(customConverters);
    }

    public List<CustomConverter> getCustomConverters() {
        return Collections.unmodifiableList(this.customConverters);
    }

    public Map<String, CustomConverter> getCustomConvertersWithId() {
        return Collections.unmodifiableMap(this.customConvertersWithId);
    }

    private void init() {
        DozerInitializer.getInstance().init();
        this.log.info("Initializing a new instance of dozer bean mapper.");
        GlobalSettings globalSettings = GlobalSettings.getInstance();
        this.cacheManager.addCache(DozerCacheType.CONVERTER_BY_DEST_TYPE.name(), globalSettings.getConverterByDestTypeCacheMaxSize());
        this.cacheManager.addCache(DozerCacheType.SUPER_TYPE_CHECK.name(), globalSettings.getSuperTypesCacheMaxSize());
        this.statsMgr.increment(StatisticType.MAPPER_INSTANCES_COUNT);
    }

    public void destroy() {
        DozerInitializer.getInstance().destroy();
    }

    protected Mapper getMappingProcessor() {
        this.initMappings();
        MappingProcessor processor = new MappingProcessor(this.customMappings, this.globalConfiguration, this.cacheManager, this.statsMgr, this.customConverters, this.eventManager, this.getCustomFieldMapper(), this.customConvertersWithId);
        if (this.statsMgr.isStatisticsEnabled()) {
            processor = (Mapper)Proxy.newProxyInstance(processor.getClass().getClassLoader(), processor.getClass().getInterfaces(), (InvocationHandler)new StatisticsInterceptor((Object)processor, this.statsMgr));
        }
        return processor;
    }

    void loadCustomMappings() {
        CustomMappingsLoader customMappingsLoader = new CustomMappingsLoader();
        List<MappingFileData> xmlMappings = this.loadFromFiles(this.mappingFiles);
        ArrayList<MappingFileData> allMappings = new ArrayList<MappingFileData>();
        allMappings.addAll(xmlMappings);
        allMappings.addAll(this.builderMappings);
        LoadMappingsResult loadMappingsResult = customMappingsLoader.load(allMappings);
        this.customMappings = loadMappingsResult.getCustomMappings();
        this.globalConfiguration = loadMappingsResult.getGlobalConfiguration();
    }

    private List<MappingFileData> loadFromFiles(List<String> mappingFiles) {
        MappingFileReader mappingFileReader = new MappingFileReader(XMLParserFactory.getInstance());
        ArrayList<MappingFileData> mappingFileDataList = new ArrayList<MappingFileData>();
        if (mappingFiles != null && mappingFiles.size() > 0) {
            this.log.info("Using the following xml files to load custom mappings for the bean mapper instance: {}", mappingFiles);
            for (String mappingFileName : mappingFiles) {
                this.log.info("Trying to find xml mapping file: {}", (Object)mappingFileName);
                URL url = MappingValidator.validateURL((String)mappingFileName);
                this.log.info("Using URL [" + url + "] to load custom xml mappings");
                MappingFileData mappingFileData = mappingFileReader.read(url);
                this.log.info("Successfully loaded custom xml mappings from URL: [{}]", (Object)url);
                mappingFileDataList.add(mappingFileData);
            }
        }
        return mappingFileDataList;
    }

    public void addMapping(InputStream xmlStream) {
        this.checkIfInitialized();
        MappingStreamReader fileReader = new MappingStreamReader(XMLParserFactory.getInstance());
        MappingFileData mappingFileData = fileReader.read(xmlStream);
        this.builderMappings.add(mappingFileData);
    }

    public void addMapping(BeanMappingBuilder mappingBuilder) {
        this.checkIfInitialized();
        MappingFileData mappingFileData = mappingBuilder.build();
        this.builderMappings.add(mappingFileData);
    }

    public List<? extends DozerEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    public void setEventListeners(List<? extends DozerEventListener> eventListeners) {
        this.checkIfInitialized();
        this.eventListeners.clear();
        this.eventListeners.addAll(eventListeners);
    }

    public CustomFieldMapper getCustomFieldMapper() {
        return this.customFieldMapper;
    }

    public void setCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.checkIfInitialized();
        this.customFieldMapper = customFieldMapper;
    }

    public MappingMetadata getMappingMetadata() {
        this.initMappings();
        return new DozerMappingMetadata(this.customMappings);
    }

    public void setCustomConvertersWithId(Map<String, CustomConverter> customConvertersWithId) {
        this.checkIfInitialized();
        this.customConvertersWithId.clear();
        this.customConvertersWithId.putAll(customConvertersWithId);
    }

    private void checkIfInitialized() {
        if (this.ready.getCount() == 0L) {
            throw new MappingException("Dozer Bean Mapper is already initialized! Modify settings before calling map()");
        }
    }

    private void initMappings() {
        if (this.initializing.compareAndSet(false, true)) {
            try {
                this.loadCustomMappings();
                this.eventManager = new DozerEventManager(this.eventListeners);
            }
            catch (RuntimeException e) {
                this.initializing.set(false);
                throw e;
            }
            finally {
                this.ready.countDown();
            }
        }
        try {
            this.ready.await();
        }
        catch (InterruptedException e) {
            this.log.error("Thread interrupted: ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

