/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.cache;

import cn.gtmap.realestate.common.core.domain.BdcZdCflxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdDjlxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdDybdclxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdDyfsDO;
import cn.gtmap.realestate.common.core.domain.BdcZdFwjgDO;
import cn.gtmap.realestate.common.core.domain.BdcZdFwlxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdFwxzDO;
import cn.gtmap.realestate.common.core.domain.BdcZdFwytDO;
import cn.gtmap.realestate.common.core.domain.BdcZdGjzwlxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdLzDO;
import cn.gtmap.realestate.common.core.domain.BdcZdMjdwDO;
import cn.gtmap.realestate.common.core.domain.BdcZdQllxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdQlrlxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdQsztDO;
import cn.gtmap.realestate.common.core.domain.BdcZdQyDO;
import cn.gtmap.realestate.common.core.domain.BdcZdSyttlxDO;
import cn.gtmap.realestate.common.core.domain.BdcZdTdsyqxzDO;
import cn.gtmap.realestate.common.core.domain.BdcZdYgdjzlDO;
import cn.gtmap.realestate.common.core.domain.BdcZdYzyfsDO;
import cn.gtmap.realestate.common.core.domain.BdcZdZjzlDO;
import cn.gtmap.realestate.common.core.dto.BdcMapZdConvertDTO;
import cn.gtmap.realestate.common.core.service.BdcZdGlService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcZdCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcZdCache.class);
    private static Map<String, List> zdCacheMap = new HashMap<String, List>(100);
    public static final List<BdcMapZdConvertDTO> defaultConvertVoList = new ArrayList<BdcMapZdConvertDTO>(50);
    @Autowired
    BdcZdGlService bdcZdGlService;

    public void addZdCacheMap(String fieldName, String cacheTable, List<Map<String, Object>> cacheData) {
        if (CollectionUtils.isNotEmpty(cacheData) && StringUtils.isNotBlank((CharSequence)cacheTable)) {
            cacheTable = StringUtils.lowerCase((String)cacheTable);
            zdCacheMap.put(cacheTable, cacheData);
            defaultConvertVoList.add(new BdcMapZdConvertDTO(StringUtils.upperCase((String)fieldName), StringUtils.upperCase((String)cacheTable)));
        }
    }

    private void refreshZdCacheMap(String cacheTable, Class cacheClass) {
        if (StringUtils.isNotBlank((CharSequence)cacheTable)) {
            cacheTable = StringUtils.lowerCase((String)cacheTable);
            try {
                List<HashMap> zdList = this.bdcZdGlService.getZdTableData(cacheClass);
                if (CollectionUtils.isNotEmpty(zdList)) {
                    zdCacheMap.put(cacheTable, zdList);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u63d2\u5165\u5b57\u5178\u7f13\u5b58\u65f6\u62a5\u9519", (Throwable)e);
            }
        }
    }

    private static List<Map> getCache(String key) {
        return zdCacheMap.get(key);
    }

    private static boolean hasCache(String key) {
        return zdCacheMap.containsKey(key);
    }

    public List<Map> getZdTableList(String cacheTable, Class cacheClass) {
        List zdList = new ArrayList<Map>(0);
        if (StringUtils.isNotBlank((CharSequence)cacheTable)) {
            if (!BdcZdCache.hasCache(cacheTable = StringUtils.lowerCase((String)cacheTable))) {
                this.refreshZdCacheMap(cacheTable, cacheClass);
            }
            if (CollectionUtils.isEmpty(zdList = BdcZdCache.getCache(cacheTable))) {
                zdList = new ArrayList(0);
            }
        }
        return zdList;
    }

    public Object getFeildValue(String cacheTable, Object getFeildValue, String returnFieldName, String getFieldName, Class cacheClass) {
        Object returnFieldValue = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cacheTable, returnFieldName, getFieldName}) && getFeildValue != null) {
            List<Map> zdList = this.getZdTableList(cacheTable, cacheClass);
            returnFieldName = StringUtils.upperCase((String)returnFieldName);
            getFieldName = StringUtils.upperCase((String)getFieldName);
            if (CollectionUtils.isNotEmpty(zdList)) {
                for (Map zdMap : zdList) {
                    if (MapUtils.getObject((Map)zdMap, (Object)getFieldName) == null || !StringUtils.equals((CharSequence)getFeildValue.toString(), (CharSequence)MapUtils.getObject((Map)zdMap, (Object)getFieldName).toString())) continue;
                    returnFieldValue = MapUtils.getObject((Map)zdMap, (Object)returnFieldName);
                    break;
                }
            }
        }
        return returnFieldValue;
    }

    public Object getFeildValue(String cacheTable, Object getFeildValue, String returnFieldName, Class cacheClass) {
        return this.getFeildValue(cacheTable, getFeildValue, returnFieldName, "DM", cacheClass);
    }

    public String getFeildValue(String cacheTable, Object getFeildValue, Class cacheClass) {
        Object returnFieldValue = this.getFeildValue(cacheTable, getFeildValue, "MC", "DM", cacheClass);
        if (returnFieldValue != null) {
            return returnFieldValue.toString();
        }
        return "";
    }

    @PostConstruct
    private static void initConvertVoList() {
        defaultConvertVoList.add(new BdcMapZdConvertDTO("DJLX", "BDC_ZD_DJLX", BdcZdDjlxDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("ZJZL", "BDC_ZD_ZJZL", BdcZdZjzlDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("MJDW", "BDC_ZD_MJDW", BdcZdMjdwDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("QLRLX", "BDC_ZD_QLRLX", BdcZdQlrlxDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("FWLX", "BDC_ZD_FWLX", BdcZdFwlxDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("FWXZ", "BDC_ZD_FWXZ", BdcZdFwxzDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("FWJG", "BDC_ZD_FWJG", BdcZdFwjgDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("FWYT", "BDC_ZD_FWYT", BdcZdFwytDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("GJZWLX", "BDC_ZD_GJZWLX", BdcZdGjzwlxDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("YZYFS", "BDC_ZD_YZYFS", BdcZdYzyfsDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("TDSYQXZ", "BDC_ZD_TDSYQXZ", BdcZdTdsyqxzDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("SYTTLX", "BDC_ZD_SYTTLX", BdcZdSyttlxDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("LZ", "BDC_ZD_LZ", BdcZdLzDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("QY", "BDC_ZD_QY", BdcZdQyDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("DYFS", "BDC_ZD_DYFS", BdcZdDyfsDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("DYBDCLX", "BDC_ZD_DYBDCLX", BdcZdDybdclxDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("YGDJZL", "BDC_ZD_YGDJZL", BdcZdYgdjzlDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("QSZT", "BDC_ZD_QSZT", BdcZdQsztDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("CFLX", "BDC_ZD_CFLX", BdcZdCflxDO.class));
        defaultConvertVoList.add(new BdcMapZdConvertDTO("QLLX", "BDC_ZD_QLLX", BdcZdQllxDO.class));
    }
}

