/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.mq.sender;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class MQSender
implements RabbitTemplate.ConfirmCallback {
    private static final Logger logger = LoggerFactory.getLogger(MQSender.class);
    @Autowired
    RabbitTemplate rabbitTemplate;

    public void send(String exchange, String routeKey, Object obj) {
        this.rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
        CorrelationData correlationData = new CorrelationData(UUID.randomUUID().toString());
        logger.warn("\u6d88\u606fid:{}", (Object)correlationData.getId());
        this.rabbitTemplate.convertAndSend(exchange, routeKey, obj, correlationData);
    }

    public abstract void saveErrorLog(CorrelationData var1, String var2);

    public void confirm(CorrelationData correlationData, boolean success, String msg) {
        if (success) {
            logger.warn("\u6d88\u606f\u53d1\u9001\u786e\u8ba4\u6210\u529f");
        } else {
            this.saveErrorLog(correlationData, msg);
            logger.error("\u6d88\u606f\u53d1\u9001\u786e\u8ba4\u5931\u8d25:{}", (Object)msg);
        }
    }
}

