/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.mq.consumer;

import cn.gtmap.realestate.common.config.mq.Config.MQConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={MQConfig.class})
public class MQConsumerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MQConsumerFactory.class);

    @Bean(value={"bdcdyRabbitListenerContainerFactory"})
    @ConditionalOnMissingBean
    public SimpleRabbitListenerContainerFactory testRabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        return factory;
    }
}

