/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.mq.Config;

import javax.annotation.Resource;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.util.StringUtils;

@Configuration
public class MQConfig {
    @Resource
    private RabbitProperties rabbitProperties;

    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        if (!StringUtils.isEmpty((Object)this.rabbitProperties.getAddresses())) {
            connectionFactory.setAddresses(this.rabbitProperties.getAddresses());
        } else {
            connectionFactory.setAddresses(this.rabbitProperties.getHost().concat(":").concat(this.rabbitProperties.getPort() + ""));
        }
        connectionFactory.setUsername(this.rabbitProperties.getUsername());
        connectionFactory.setPassword(this.rabbitProperties.getPassword());
        connectionFactory.setPublisherConfirms(true);
        return connectionFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    public RabbitTemplate rabbitTemplate() {
        RabbitTemplate template = new RabbitTemplate(this.connectionFactory());
        return template;
    }
}

