/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.logaop;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.config.logaop.LogCommonEventAspect;
import cn.gtmap.realestate.common.core.dto.inquiry.BdcPrintLogDTO;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.stereotype.Component;

@Component
public class PrintLogUtils {
    @Autowired
    private UserManagerUtils userManagerUtils;
    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCommonEventAspect.class);

    public void savePrintLog(BdcPrintLogDTO bdcPrintLogDTO) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String userName = this.userManagerUtils.getCurrentUserName();
        UserDto userDto = this.userManagerUtils.getUserByName(userName);
        if (userDto != null) {
            data.put("alias", userDto.getAlias());
            data.put("organization", this.userManagerUtils.getOrganizationByUserName(userName));
        }
        data.put("modelUrl", bdcPrintLogDTO.getModelUrl());
        data.put("dataUrl", bdcPrintLogDTO.getDataUrl());
        data.put("xmlStr", bdcPrintLogDTO.getXmlStr());
        data.put("viewTypeName", "\u6253\u5370\u64cd\u4f5c\u8bb0\u5f55");
        if (bdcPrintLogDTO.getPrivateAttrMap() != null) {
            data.putAll(bdcPrintLogDTO.getPrivateAttrMap());
        }
        AuditEvent auditEvent = new AuditEvent(userName, "PRINTLOG", data);
        try {
            this.zipkinAuditEventRepository.add(auditEvent);
        }
        catch (Exception e) {
            LOGGER.error("-------\u65e5\u5fd7\u8bb0\u5f55\u63a5\u53e3\u51fa\u9519-------" + e.getMessage());
        }
    }
}

