/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.logaop;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.core.annotations.LogNote;
import cn.gtmap.realestate.common.core.enums.LogKeyEnum;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LogNoteAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogNoteAspect.class);
    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;
    @Autowired
    private UserManagerUtils userManagerUtils;

    @Pointcut(value="@annotation(logNote)")
    public void pointCut(LogNote logNote) {
    }

    @Before(value="pointCut(logNote)")
    public void doBeforeLog(JoinPoint point, LogNote logNote) {
        HashMap<String, String> data = new HashMap<String, String>(3);
        data.put(LogKeyEnum.VIEW_TYPE_NAME.getKey(), logNote.value());
        Object[] args = point.getArgs();
        String[] argsName = ((MethodSignature)point.getSignature()).getParameterNames();
        data.put("ARGS", JSON.toJSONString((Object)point.getArgs()));
        String logType = StringUtils.isEmpty((CharSequence)logNote.action()) ? "OTHER" : logNote.action();
        String userName = this.userManagerUtils.getCurrentUserName();
        UserDto userDto = this.userManagerUtils.getUserByName(userName);
        if (userDto != null) {
            data.put("alias", userDto.getAlias());
        }
        try {
            this.zipkinAuditEventRepository.add(new AuditEvent(userName, logType, data));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }
}

