/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.logaop;

import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.config.logaop.LogParamsTslConstants;
import cn.gtmap.realestate.common.core.annotations.LogCommonEvent;
import cn.gtmap.realestate.common.util.CommonUtil;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.servlet.ModelAndView;

@Component
@Aspect
public class LogCommonEventAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogCommonEventAspect.class);
    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;
    @Autowired
    private UserManagerUtils userManagerUtils;

    @Pointcut(value="@annotation(logEvent)")
    public void logEventPointCut(LogCommonEvent logEvent) {
    }

    @AfterReturning(returning="response", pointcut="logEventPointCut(logEvent)")
    public void doAfter(JoinPoint joinPoint, LogCommonEvent logEvent, Object response) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        if (StringUtils.isBlank((CharSequence)logEvent.event())) {
            LOGGER.error("\u65b9\u6cd5\u5f02\u5e38\uff1a\u672a\u6307\u5b9a\u65e5\u5fd7\u4e8b\u4ef6\uff01");
        } else {
            JSONObject paramObj = this.analysisMethodParam(methodSignature.getParameterNames(), joinPoint.getArgs());
            Map<String, Object> data = this.getAuditEventParam(logEvent.names(), paramObj);
            data.put("viewType", logEvent.modelDm());
            data.put("viewTypeName", logEvent.modelMc());
            data.put("ip", LogCommonEventAspect.getIpAddress());
            AuditEvent auditEvent = new AuditEvent(this.userManagerUtils.getCurrentUserName(), logEvent.event(), data);
            this.zipkinAuditEventRepository.add(auditEvent);
        }
    }

    private Map<String, Object> getAuditEventParam(String[] names, JSONObject param) {
        HashMap map = Maps.newHashMap();
        Map<String, String> paramConfig = LogParamsTslConstants.PARAM;
        if (MapUtils.isNotEmpty(paramConfig) && !param.isEmpty()) {
            Map tempMap = (Map)JSONObject.parseObject((String)param.toJSONString(), Map.class);
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (tempMap.containsKey(names[i])) continue;
                    tempMap.remove(names[i]);
                }
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                if (!paramConfig.containsKey(((String)entry.getKey()).toUpperCase())) continue;
                map.put("param_" + (String)entry.getKey(), tempMap.get(entry.getKey()));
            }
            if (param.containsKey((Object)"viewType")) {
                map.put("viewType", tempMap.get("viewType"));
            }
        }
        return map;
    }

    private JSONObject analysisMethodParam(String[] paramNames, Object[] paramValue) {
        JSONObject param = new JSONObject();
        if (paramNames != null && paramValue != null) {
            for (int i = 0; i < paramValue.length; ++i) {
                if (paramValue[i] == null || paramValue[i] instanceof HttpServletRequest || paramValue[i] instanceof HttpServletResponse || paramValue[i] instanceof Model || paramValue[i] instanceof ModelAndView || paramValue[i] instanceof Authentication || paramValue[i] instanceof OAuth2Authentication) continue;
                if (CommonUtil.isJSONObject(JSONObject.toJSONString((Object)paramValue[i]))) {
                    this.recursiveMethodParam(param, paramNames[i], JSONObject.toJSONString((Object)paramValue[i]));
                    continue;
                }
                this.recursiveMethodParam(param, paramNames[i], paramValue[i].toString());
            }
        }
        return param;
    }

    private void recursiveMethodParam(JSONObject result, String paramName, String jsonStr) {
        if (result == null) {
            result = new JSONObject();
        }
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            if (CommonUtil.isJSONObject(jsonStr)) {
                JSONObject temp = JSONObject.parseObject((String)jsonStr);
                if (temp != null) {
                    for (Map.Entry entry : temp.entrySet()) {
                        this.recursiveMethodParam(result, (String)entry.getKey(), temp.get(entry.getKey()).toString());
                    }
                }
            } else if (CommonUtil.isJSONOArray(jsonStr)) {
                JSONArray tempList = JSONArray.parseArray((String)jsonStr);
                result.put(paramName, (Object)StringUtils.join((Iterable)tempList, (String)","));
            } else {
                result.put(paramName, (Object)jsonStr);
            }
        }
    }

    private static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || netInterface.isPointToPoint() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u672c\u673aip\u65b9\u6cd5\u5f02\u5e38\uff01");
        }
        return "";
    }
}

