/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.logaop;

import cn.gtmap.realestate.common.config.logaop.LogCommonCacheMap;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Extension;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LogApiOprationAspect {
    @Pointcut(value="@annotation(apiOperation)")
    public void logApiPointCut(ApiOperation apiOperation) {
    }

    @AfterReturning(returning="response", pointcut="logApiPointCut(apiOperation)")
    public void doAfter(JoinPoint joinPoint, ApiOperation apiOperation, Object response) {
        Extension est;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        if (apiOperation.extensions() != null && apiOperation.extensions().length > 0 && (est = apiOperation.extensions()[0]).properties() != null && est.properties().length > 0) {
            String name = est.properties()[0].name();
            String value = est.properties()[0].value();
            if ("saveLog".equals(name)) {
                LogCommonCacheMap.methodLogEntity.put(methodSignature.getName() + "_saveLog", value);
            }
        }
        LogCommonCacheMap.methodLogEntity.put(methodSignature.getName(), apiOperation.value());
    }
}

