/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.logaop;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.config.logaop.LogCommonCacheMap;
import cn.gtmap.realestate.common.core.annotations.LogNote;
import cn.gtmap.realestate.common.util.CommonUtil;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiImplicitParams;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.ModelAndView;

@Component
@Aspect
public class LogApiAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogApiAspect.class);
    private static final String UNKNOWN = "unknown";
    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;
    @Autowired
    private UserManagerUtils userManagerUtils;

    @Pointcut(value="@annotation(apiImplicitParams)")
    public void logApiPointCut(ApiImplicitParams apiImplicitParams) {
    }

    @AfterReturning(returning="response", pointcut="logApiPointCut(apiImplicitParams)")
    public void doAfter(JoinPoint joinPoint, ApiImplicitParams apiImplicitParams, Object response) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        try {
            Object target = joinPoint.getTarget();
            Method method = target.getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
            if (null != method.getAnnotation(LogNote.class)) {
                return;
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7b7e\u540d:" + methodSignature.getName() + " \u7684\u65b9\u6cd5");
            return;
        }
        if (!LogCommonCacheMap.methodLogEntity.containsKey(methodSignature.getName()) || StringUtils.isEmpty((CharSequence)LogCommonCacheMap.methodLogEntity.get(methodSignature.getName()))) {
            LOGGER.error("-------" + methodSignature.getName() + "\u65b9\u6cd5\u7f3a\u5c11\u65e5\u5fd7\u6ce8\u89e3\uff01-------");
            return;
        }
        if (LogCommonCacheMap.methodLogEntity.containsKey(methodSignature.getName() + "_saveLog") && LogCommonCacheMap.methodLogEntity.get(methodSignature.getName() + "_saveLog").equals("false")) {
            return;
        }
        JSONObject paramObj = this.analysisMethodParam(methodSignature.getParameterNames(), joinPoint.getArgs());
        Map<String, Object> data = this.getAuditEventParam(new String[0], paramObj);
        try {
            data.put("mvc.controller.method", methodSignature.getName());
        }
        catch (Exception e) {
            data.put("mvc.controller.method", UNKNOWN);
        }
        try {
            String mkdm = methodSignature.toString().split("\\.")[3].toUpperCase();
            data.put("viewType", mkdm);
        }
        catch (Exception e) {
            data.put("viewType", UNKNOWN);
        }
        String mkmc = "";
        String action = "";
        try {
            String mkmcstr = LogCommonCacheMap.methodLogEntity.get(methodSignature.getName());
            if (mkmcstr.indexOf("#") > -1) {
                mkmc = mkmcstr.split("#")[0];
                action = mkmcstr.split("#")[1];
            } else {
                mkmc = mkmcstr;
            }
            data.put("viewTypeName", mkmc);
        }
        catch (Exception e) {
            data.put("viewTypeName", "\u672a\u77e5\u64cd\u4f5c");
        }
        if (StringUtils.isEmpty((CharSequence)action)) {
            action = StringUtils.isEmpty((CharSequence)mkmc) ? "OTHER" : LogApiAspect.analysisEventAction(mkmc);
        }
        data.put("ip", LogApiAspect.getRealIPAddress());
        String userName = this.userManagerUtils.getCurrentUserName();
        UserDto userDto = this.userManagerUtils.getUserByName(userName);
        if (userDto != null) {
            data.put("alias", userDto.getAlias());
        }
        AuditEvent auditEvent = new AuditEvent(userName, action, data);
        try {
            this.zipkinAuditEventRepository.add(auditEvent);
        }
        catch (Exception e) {
            LOGGER.error("-------\u65e5\u5fd7\u8bb0\u5f55\u63a5\u53e3\u51fa\u9519-------" + e.getMessage());
        }
        LogCommonCacheMap.methodLogEntity.clear();
    }

    private Map<String, Object> getAuditEventParam(String[] names, JSONObject param) {
        HashMap map = Maps.newHashMap();
        Map tempMap = (Map)JSONObject.parseObject((String)param.toJSONString(), Map.class);
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (tempMap.containsKey(names[i])) continue;
                tempMap.remove(names[i]);
            }
        }
        for (Map.Entry entry : tempMap.entrySet()) {
            map.put(entry.getKey(), tempMap.get(entry.getKey()));
        }
        if (param.containsKey((Object)"viewType")) {
            map.put("viewType", tempMap.get("viewType"));
        }
        if (param.containsKey((Object)"clientIp")) {
            map.put("clientIp", tempMap.get("clientIp"));
        }
        return map;
    }

    private JSONObject analysisMethodParam(String[] paramNames, Object[] paramValue) {
        JSONObject param = new JSONObject();
        if (paramNames != null && paramValue != null) {
            for (int i = 0; i < paramValue.length; ++i) {
                if (paramValue[i] == null || paramValue[i] instanceof HttpServletRequest || paramValue[i] instanceof HttpServletResponse || paramValue[i] instanceof Model || paramValue[i] instanceof ModelAndView || paramValue[i] instanceof Authentication || paramValue[i] instanceof OAuth2Authentication) continue;
                if (CommonUtil.isJSONObject(JSONObject.toJSONString((Object)paramValue[i]))) {
                    this.recursiveMethodParam(param, paramNames[i], JSONObject.toJSONString((Object)paramValue[i]));
                    continue;
                }
                this.recursiveMethodParam(param, paramNames[i], paramValue[i].toString());
            }
        }
        return param;
    }

    private void recursiveMethodParam(JSONObject result, String paramName, String jsonStr) {
        if (result == null) {
            result = new JSONObject();
        }
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            if (CommonUtil.isJSONObject(jsonStr)) {
                JSONObject temp = JSONObject.parseObject((String)jsonStr);
                if (temp != null) {
                    for (Map.Entry entry : temp.entrySet()) {
                        this.recursiveMethodParam(result, (String)entry.getKey(), temp.get(entry.getKey()).toString());
                    }
                }
            } else if (CommonUtil.isJSONOArray(jsonStr)) {
                JSONArray tempList = JSONArray.parseArray((String)jsonStr);
                result.put(paramName, (Object)StringUtils.join((Iterable)tempList, (String)","));
            } else {
                result.put(paramName, (Object)jsonStr);
            }
        }
    }

    private static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || netInterface.isPointToPoint() || !netInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address)) continue;
                    return ip.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u672c\u673aip\u65b9\u6cd5\u5f02\u5e38\uff01");
        }
        return "";
    }

    private static String getRealIPAddress() {
        String ip;
        block6: {
            block7: {
                ip = "";
                ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
                if (attributes == null) break block6;
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                ip = request.getHeader("X-Forwarded-For");
                if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip)) break block7;
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (ip != null && ip.length() != 0 && !UNKNOWN.equalsIgnoreCase(ip)) break block6;
                ip = request.getRemoteAddr();
                break block6;
            }
            if (ip.length() > 15) {
                String[] ips = ip.split(",");
                for (int index = 0; index < ips.length; ++index) {
                    String strIp = ips[index];
                    if (UNKNOWN.equalsIgnoreCase(strIp)) continue;
                    ip = strIp;
                    break;
                }
            }
        }
        return ip;
    }

    private static String analysisEventAction(String description) {
        String action = "";
        action = description.indexOf("\u67e5\u8be2") != -1 || description.indexOf("\u83b7\u53d6") != -1 ? "QUERY" : (description.indexOf("\u5bfc\u51fa") != -1 || description.indexOf("\u4e0b\u8f7d") != -1 ? "EXPORT" : (description.indexOf("\u4e0a\u4f20") != -1 ? "UPLOAD" : (description.indexOf("\u4fdd\u5b58") != -1 || description.indexOf("\u8bb0\u5f55") != -1 ? "SAVE" : (description.indexOf("\u5220\u9664") != -1 ? "DELETE" : (description.indexOf("\u65b0\u589e") != -1 || description.indexOf("\u751f\u6210") != -1 || description.indexOf("\u521b\u5efa") != -1 || description.indexOf("\u65b0\u5efa") != -1 ? "CREATE" : (description.indexOf("\u6253\u5370") != -1 ? "PRINT" : (description.indexOf("\u66f4\u65b0") != -1 || description.indexOf("\u540c\u6b65") != -1 ? "UPDATE" : "OTHER")))))));
        return action;
    }
}

