/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.logaop;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.core.dto.register.DbLogDTO;
import cn.gtmap.realestate.common.core.enums.LogKeyEnum;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.stereotype.Component;

@Component
public class DbLogUtils {
    @Autowired
    private UserManagerUtils userManagerUtils;
    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLogUtils.class);

    public void saveDbLog(DbLogDTO dbLogDTO) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String userName = this.userManagerUtils.getCurrentUserName();
        UserDto userDto = this.userManagerUtils.getUserByName(userName);
        if (userDto != null) {
            data.put("alias", userDto.getAlias());
        }
        data.put(LogKeyEnum.EVENT_NAME.getKey(), "\u624b\u52a8\u767b\u7c3f\u64cd\u4f5c\u65e5\u5fd7");
        if (dbLogDTO.getPrivateAttrMap() != null) {
            data.putAll(dbLogDTO.getPrivateAttrMap());
        }
        AuditEvent auditEvent = new AuditEvent(userName, "SDDB", data);
        try {
            this.zipkinAuditEventRepository.add(auditEvent);
        }
        catch (Exception e) {
            LOGGER.error("-------\u65e5\u5fd7\u8bb0\u5f55\u63a5\u53e3\u51fa\u9519-------" + e.getMessage());
        }
    }

    public void saveMqSendLog(String exchange, String routeKey, Object obj) {
        LOGGER.warn("\u767b\u7c3fMq\u53d1\u9001\u65e5\u5fd7\u8bb0\u5f55saveMqSendLog,exchange:{},routeKey:{},obj{}", new Object[]{exchange, routeKey, obj});
        HashMap<String, Object> data = new HashMap<String, Object>();
        String userName = this.userManagerUtils.getCurrentUserName();
        UserDto userDto = this.userManagerUtils.getUserByName(userName);
        if (userDto != null) {
            data.put("alias", userDto.getAlias());
        }
        data.put(LogKeyEnum.EVENT_NAME.getKey(), "\u767b\u7c3fMq\u53d1\u9001\u64cd\u4f5c\u65e5\u5fd7");
        data.put("exchange", exchange);
        data.put("routeKey", routeKey);
        data.put("sendData", obj);
        AuditEvent auditEvent = new AuditEvent(userName, "SDDB", data);
        try {
            this.zipkinAuditEventRepository.add(auditEvent);
        }
        catch (Exception e) {
            LOGGER.error("-------\u65e5\u5fd7\u8bb0\u5f55\u63a5\u53e3\u51fa\u9519-------" + e.getMessage());
        }
    }
}

