/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config.interceptor;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.msg.domain.dto.AnonymousContentDto;
import cn.gtmap.gtc.msg.domain.dto.ProduceMsgDto;
import cn.gtmap.gtc.msg.domain.enums.ConsumerType;
import cn.gtmap.gtc.msg.domain.enums.MsgReadFlag;
import cn.gtmap.gtc.msg.domain.enums.OperationType;
import cn.gtmap.gtc.msg.domain.enums.ProducerType;
import cn.gtmap.gtc.msg.rabbitmq.produce.MessageProducer;
import cn.gtmap.realestate.common.core.domain.BdcMsgConfig;
import cn.gtmap.realestate.common.core.domain.BdcMsgLog;
import cn.gtmap.realestate.common.core.domain.BdcMsgMain;
import cn.gtmap.realestate.common.core.service.feign.init.BdcRunSqlFeignService;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

@Component
@Import(value={EntityMapper.class, MessageProducer.class, BdcRunSqlFeignService.class})
public class SendMsgInterceptor
implements HandlerInterceptor {
    @Value(value="${security.oauth2.client.client-id}")
    private String clientId;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private MessageProducer messageProducer;
    @Autowired
    private BdcRunSqlFeignService bdcRunSqlFeignService;
    private static final Logger logger = LoggerFactory.getLogger(SendMsgInterceptor.class);
    public static List<String> urlList;

    public static List<String> getUrlList() {
        return urlList;
    }

    @PostConstruct
    public void init() {
        this.initMap();
    }

    public void initMap() {
        Example example = new Example(BdcMsgMain.class);
        List configList = this.entityMapper.selectByExample(example);
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(configList)) {
            for (BdcMsgMain main : configList) {
                list.add(main.getUrl());
            }
        }
        urlList = list;
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        this.sendMsg(httpServletRequest, httpServletResponse);
    }

    @Async
    public void sendMsg(HttpServletRequest request, HttpServletResponse response) {
        AntPathMatcher matcher = new AntPathMatcher();
        ArrayList phoneList = new ArrayList();
        if (CollectionUtils.isNotEmpty(urlList)) {
            for (String url : urlList) {
                if (!matcher.match(url, request.getRequestURI())) continue;
                logger.info("\u5f53\u524durl\u88ab\u62e6\u622a\uff0c\u62e6\u622a\u4e3a\uff1a" + url + "\u88ab\u62e6\u622aurl\u4e3a\uff1a" + request.getRequestURI());
                if (response.getStatus() != 200) continue;
                Example msgMainExample = new Example(BdcMsgMain.class);
                msgMainExample.createCriteria().andEqualTo("url", url);
                List<BdcMsgMain> msgMainList = this.entityMapper.selectByExample(msgMainExample);
                if (!CollectionUtils.isNotEmpty(msgMainList)) continue;
                msgMainList.forEach(main -> {
                    String msgType = this.getMsgType((BdcMsgMain)main);
                    if (StringUtils.isNotBlank((CharSequence)main.getParamWhere()) && StringUtils.isNotBlank((CharSequence)main.getParamSql())) {
                        ServletWebRequest webRequest = new ServletWebRequest(request);
                        Map map = (Map)webRequest.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
                        String parmWhereSql = "";
                        parmWhereSql = StringUtil.isNotBlank((CharSequence)MapUtils.getString((Map)map, (Object)main.getParamWhere())) ? main.getParamSql().replace("@{" + main.getParamWhere() + "}", "'" + (String)map.get(main.getParamWhere()) + "'") : main.getParamSql().replace("@{" + main.getParamWhere() + "}", "'" + request.getParameter(main.getParamWhere()) + "'");
                        logger.info("\u53d1\u9001\u77ed\u4fe1\u529f\u80fdsql\u6267\u884c\uff1a" + parmWhereSql);
                        List<HashMap> parmMapList = this.bdcRunSqlFeignService.runSql(parmWhereSql);
                        if (CollectionUtils.isNotEmpty(parmMapList)) {
                            parmMapList.forEach(hashMap -> {
                                String phone = MapUtils.getString((Map)hashMap, (Object)"dh");
                                if (StringUtils.isNotBlank((CharSequence)phone) && StringUtils.isNotBlank((CharSequence)msgType) && hashMap != null) {
                                    if (this.checkPhone(phone)) {
                                        if (!phoneList.contains(phone)) {
                                            this.smsMsg((Map<String, String>)hashMap, phone, msgType);
                                            this.saveMsgLog(JSON.toJSONString((Object)hashMap), String.valueOf(response.getStatus()), phone, "0", "\u53d1\u9001\u6210\u529f");
                                            phoneList.add(phone);
                                        }
                                    } else {
                                        this.saveMsgLog(JSON.toJSONString((Object)hashMap), String.valueOf(response.getStatus()), phone, "1", "\u7535\u8bdd\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
                                    }
                                } else {
                                    this.saveMsgLog(JSON.toJSONString((Object)hashMap), String.valueOf(response.getStatus()), phone, "1", "\u53c2\u6570\u7f3a\u5931");
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    private void saveMsgLog(String parma, String status, String phone, String issuccess, String errorMsg) {
        BdcMsgLog log = new BdcMsgLog();
        log.setLogid(UUIDGenerator.generate16());
        log.setIssucc(issuccess);
        log.setParam(parma);
        log.setPhone(phone);
        log.setReturncode(status);
        log.setSendtime(new Date());
        log.setException(errorMsg);
        this.entityMapper.insertSelective(log);
    }

    private boolean checkPhone(String phone) {
        String regex = "^((13[0-9])|(14[5,7,9])|(15([0-3]|[5-9]))|(166)|(17[0,1,3,5,6,7,8])|(18[0-9])|(19[8|9]))\\d{8}$";
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            if (phone.length() != 11) {
                return false;
            }
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(phone);
            return m.matches();
        }
        return false;
    }

    private String getMsgType(BdcMsgMain main) {
        BdcMsgConfig msgConfig;
        if (main != null && StringUtils.isNotBlank((CharSequence)main.getConfigid()) && (msgConfig = this.entityMapper.selectByPrimaryKey(BdcMsgConfig.class, main.getConfigid())) != null && StringUtils.isNotBlank((CharSequence)msgConfig.getMsgtype())) {
            return msgConfig.getMsgtype();
        }
        return null;
    }

    public void smsMsg(Map<String, String> data, String phone, String msgType) {
        ProduceMsgDto msgDto = new ProduceMsgDto();
        try {
            msgDto.setClientId(this.clientId).setMsgCode(System.currentTimeMillis() + "").setMsgType(msgType).setMsgTypeName("\u77ed\u4fe1\u53d1\u9001").setProducer(this.clientId).setProducerType(ProducerType.SYSTEM.getName()).setRead(MsgReadFlag.UNREAD.getValue()).setOptions(OperationType.SMS.getName());
            msgDto.setConsumer(phone).setConsumerType(ConsumerType.ANONYMOUS.getName());
            AnonymousContentDto contentDto = new AnonymousContentDto();
            contentDto.setMobile(phone).setContent(ObjectMapperUtils.toJson(data));
            msgDto.setMsgContent(ObjectMapperUtils.toJson((Object)contentDto));
            this.messageProducer.send(msgDto);
        }
        catch (Exception e) {
            logger.error("smsMsg", (Throwable)e);
        }
    }
}

