/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.config;

import cn.gtmap.realestate.common.util.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
public class AutomaticLoadingConfig {
    @Autowired
    private ConfigurableEnvironment configurableEnvironment;
    @Autowired
    private RedisUtils redisUtils;
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomaticLoadingConfig.class);

    @PostConstruct
    public void initSystemConfig() {
        String loadConfigFromDataBaseFlag = "false";
        String name = "DataBasePropertySources";
        MutablePropertySources propertySources = this.configurableEnvironment.getPropertySources();
        ConcurrentHashMap ymlConfig = new ConcurrentHashMap();
        for (String[] source : propertySources) {
            ymlConfig.putAll((Map)JSON.parse((String)JSON.toJSON((Object)source.getSource()).toString()));
        }
        if (ymlConfig.containsKey("config.loadingConfigFlag") && Objects.nonNull(ymlConfig.get("config.loadingConfigFlag"))) {
            loadConfigFromDataBaseFlag = ymlConfig.get("config.loadingConfigFlag").toString();
            LOGGER.info("loadConfigFromDataBaseFlag from yml:{}", (Object)loadConfigFromDataBaseFlag);
        }
        if (ymlConfig.containsKey("apollo.bootstrap.namespaces") && Objects.nonNull(ymlConfig.get("apollo.bootstrap.namespaces"))) {
            String[] namespaces;
            for (String namespace : namespaces = ymlConfig.get("apollo.bootstrap.namespaces").toString().split(",")) {
                Config appConfig = ConfigService.getConfig((String)namespace);
                Set propertyNames = appConfig.getPropertyNames();
                if (!propertyNames.contains("config.loadingConfigFlag")) continue;
                loadConfigFromDataBaseFlag = appConfig.getProperty("config.loadingConfigFlag", "false");
                LOGGER.info("loadConfigFromDataBaseFlag from apollo:{}", (Object)loadConfigFromDataBaseFlag);
            }
        }
        LOGGER.info("is loading config from dataBase:{}", (Object)loadConfigFromDataBaseFlag);
        if (StringUtils.equals((String)"true", (String)loadConfigFromDataBaseFlag)) {
            Map<Object, Object> configFromDataBase = this.redisUtils.getHash("REDIS_TSYW_PZ");
            LOGGER.info("config date size from redis:{}", (Object)configFromDataBase.size());
            LOGGER.info("config date from redis:{}", (Object)JSON.toJSONString(configFromDataBase));
            Properties properties = new Properties();
            properties.putAll(configFromDataBase);
            PropertiesPropertySource dataBaseConstants = new PropertiesPropertySource(name, properties);
            propertySources.addFirst((PropertySource)dataBaseConstants);
        }
    }
}

