package cn.gtmap.realestate.common.util;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;

/**
 * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
 * @version 1.0, 2019/8/19
 * @description
 */
public class Base64Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64Utils.class);

    /**
     * 将base64位码转换为文件
     * @param base64
     * @return
     */
    public static MultipartFile base64ToMultipart(String base64) {
        try {
            String[] baseStrs = base64.split(",");
            if(baseStrs.length > 1){
                BASE64Decoder decoder = new BASE64Decoder();
                byte[] b = decoder.decodeBuffer(baseStrs[1]);
                for(int i = 0; i < b.length; ++i) {
                    if (b[i] < 0) {
                        b[i] += 256;
                    }
                }
                return new BASE64DecodedMultipartFile(b, baseStrs[0]);
            }
        } catch (IOException e) {
            return null;
        }
        return null;
    }

    /**
     * @param bytes 字节信息
     * @return String base64字符串
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 将字节base64加密
     */
    public static String encodeByteToBase64Str(byte[] bytes) {

        String base64Str = "";
        if (null != bytes) {
            base64Str = Base64.encodeBase64String(bytes);
        }
        return base64Str;
    }


    /**
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @param base64Str base64字符串
     * @return byte[]
     * @description 将base64字符串解密
     */
    public static byte[] decodeBase64StrToByte(String base64Str) {
        byte[] bytes = null;
        if (StringUtils.isNotBlank(base64Str)) {
            bytes = Base64.decodeBase64(base64Str);
        }
        return bytes;
    }

    /**
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @param
     * @return
     * @description 将base64信息解密为文件
     */
    public static boolean decodeBase64StrToFile(String base64Str, String filePath) {
        byte[] bytes = decodeBase64StrToByte(base64Str);
        if (null != bytes) {
            String path = byteToFile(filePath, bytes);
            if (StringUtils.isNotBlank(path)) {
                return true;
            }
        }
        return false;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 将字节信息转换为文件，返回文件路径
     */
    public static String byteToFile(String filePath, byte[] file) {
        try {
            FileUtils.writeByteArrayToFile(new File(filePath), file);
            return filePath;
        } catch (IOException e) {
            LOGGER.error("byteToFile", e);
        }
        return null;
    }

    /**
     * @param
     * @return
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 将base64信息，转换为jpg格式的图片文件流输出
     */
    public static void changeBase64ToImage(String imageStr, String filename, String formatName, HttpServletResponse response) {
        response.setContentType("image/jpeg");
        response.setDateHeader("expries", -1);
        //浏览器不缓存
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.addHeader("Content-Disposition", "attachment; filename=" + filename);
        ByteArrayInputStream bis = null;

        try {
            byte[] bytes = Base64Utils.decodeBase64StrToByte(imageStr);
            bis = new ByteArrayInputStream(bytes);
            BufferedImage image = ImageIO.read(bis);
            int width = (int) (image.getWidth(null) * 0.5);
            int height = (int) (image.getHeight(null) * 0.5);
            BufferedImage bufferImage= new BufferedImage (width,height,BufferedImage.TYPE_INT_RGB);
            bufferImage.getGraphics().drawImage(image,0,0,width,height,image.getGraphics().getColor(),null);//设置底色
            ImageIO.write(bufferImage, formatName, response.getOutputStream());
        } catch (IOException e) {
            LOGGER.error("图像转换异常！", e);
        } finally {
            if (bis != null) {
                try {
                    bis.close();
                } catch (IOException e) {
                    LOGGER.error("关闭流异常", e);
                }
            }
        }
    }

    public static void base64StringToPdf(String base64Content,String filePath) {

        BASE64Decoder decoder = new BASE64Decoder();
        BufferedInputStream bin = null;
        FileOutputStream fout = null;
        BufferedOutputStream bout = null;
        try {
            //将base64编码的字符串解码成字节数组
            byte[] bytes = decoder.decodeBuffer(base64Content);
            //创建一个将bytes作为其缓冲区的ByteArrayInputStream对象
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            //创建从底层输入流中读取数据的缓冲输入流对象
            bin = new BufferedInputStream(bais);
            //创建到指定文件的输出流
            File file = new File(filePath);
            fout = new FileOutputStream(file);
            //为文件输出流对接缓冲输出流对象
            bout = new BufferedOutputStream(fout);

            byte[] buffers = new byte[1024];
            int len = bin.read(buffers);
            while (len != -1) {
                bout.write(buffers, 0, len);
                len = bin.read(buffers);
            }
            //刷新此输出流并强制写出所有缓冲的输出字节，必须这行代码，否则有可能有问题
            bout.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                bout.close();
                fout.close();
                bin.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
