package cn.gtmap.realestate.common.util;

/**
 * version 1.0
 * @description 查询常量
 * @author <a href ="mailto:wangwei2@gtmap.cn">wangwei2</a>
 */
public class AnalysisLogConstants {

    /** 查询子系统代码*/
    public static final String INQUIRY_DM = "inquiry";

    /** 查询子系统名称*/
    public static final String INQUIRY_MC = "查询子系统";

    /** 台账类型--住房查询*/
    public static final String VIEW_TYPE_ZFCX = "zfcx";

    /** 台账类型--信息公开查询*/
    public static final String VIEW_TYPE_XXGKCX = "xxgkcx";

    /** 台账类型--证书证明查询*/
    public static final String VIEW_TYPE_ZSZMCX = "zszmcx";

    /** 台账类型--不动产单元查询*/
    public static final String VIEW_TYPE_BDCDYCX = "bdcdycx";

    /**
     * event：查询
     */
    public static final String LOG_EVENT_QUERY = "QUERY";

    /**
     * event：打印
     */
    public static final String LOG_EVENT_PRINT = "PRINT";

    /**
     * event：导出
     */
    public static final String LOG_EVENT_EXPORT = "EXPORT";

    /**
     * event：上传
     */
    public static final String LOG_EVENT_UPLOAD = "UPLOAD";

    /**
     * event：下载
     */
    public static final String LOG_EVENT_DOWNLOAD = "DOWNLOAD";

    /**
     * event：删除
     */
    public static final String LOG_EVENT_DELETE = "DELETE";

    /**
     * event：新建
     */
    public static final String LOG_EVENT_CREATE = "CREATE";

    /**
     * event
     */
    public static final String LOG_EVENT = "event";

    /**
     * 标记为查询条件参数
     */
    public static final String PARAM_SUB = "param_";

    /**
     * 标记为查询台账参数
     */
    public static final String VIEW_SUB = "view_";

    /**
     * Controller Name
     */
    public static final String CONTROLLER_CLASS_NAME = "mvc.controller.class";

    /**
     * Method Name
     */
    public static final String CONTROLLER_METHOD_NAME = "mvc.controller.method";

    /**
     * 用户名
     */
    public static final String USER_NAME = "principal";
    /**
     * 响应结果
     */
    public static final String RESPONSE = "response";


    public static final String DETAILS = "details";

    /**
     * 操作IP
     */
    public static final String DETAILS_REMOTEADDRESS = "remoteAddress";

    /**
     * 操作IP
     */
    public static final String IP = "ip";


    /**
     * 日志查询-模糊查询
     */
    public static final String TYPE_LIKE = "like";
    /**
     * 日志查询-精确查询
     */
    public static final String TYPE_EQUAL = "equal";

    /**
     * 查询结果中部分数据 保存的key
     */
    public static final String RESPONSE_PARAM_KEY = "response_key";

    /**
     * 台账类型
     */
    public static final String VIEW_TYPE = "viewType";

    /**
     * 台账名称
     */
    public static final String VIEW_TYPE_NAME = "viewTypeName";

    /**
     * 台账地址
     */
    public static final String VIEW_ADDRESS = "viewAddress";

    /**
     * 拼接查询条件得分隔符
     */
    public static final String separate = "， ";


    /**
     * 文件名称
     */
    public static final String FILE_NAME = "fileName";

    /**
     * 文件路径
     */
    public static final String FILE_PATH = "filePath";


    /**
     * fr3 打印模板名称
     */
    public static final String FR3_TEMPLAT = "templatName";


    /**
     * 需要保存到日志中的查询参数
     */
    public static final String PARAM_LIST = "paramList";


}
