package cn.gtmap.realestate.common.core.vo.inquiry;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

/**
 * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
 * @version 1.3, 2019-07-19
 * @description 不动产异议台账VO
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "@Clazz",defaultImpl = BdcYyVO.class)
@ApiModel(value = "BdcYyVO",description = "不动产异议VO")
public class BdcYyVO implements Serializable {
    private static final long serialVersionUID = -7682838389613044624L;
    @ApiModelProperty(value = "权利人")
    private String qlr;
    @ApiModelProperty(value = "权利id")
    private String qlid;
    @ApiModelProperty(value = "异议事项")
    private String yysx;
    @ApiModelProperty(value = "注销异议业务号")
    private String zxyyywh;
    @ApiModelProperty(value = "注销异议原因")
    private String zxyyyy;
    @ApiModelProperty(value = "注销异议登记时间",example = "2018-10-01 12:18:48")
    private Date zxyydjsj;
    @ApiModelProperty(value = "注销异议登簿人")
    private String zxyydbr;
    @ApiModelProperty(value = "受理编号")
    private String slbh;
    @ApiModelProperty(value = "项目ID")
    private String xmid;
    @ApiModelProperty(value = "共有情况")
    private String gyqk;
    @ApiModelProperty(value = "登记时间",example = "2018-10-01 12:18:48")
    private Date djsj;
    @ApiModelProperty(value = "登簿人")
    private String dbr;
    @ApiModelProperty(value = "登记机构")
    private String djjg;
    @ApiModelProperty(value = "附记")
    private String fj;
    @ApiModelProperty(value = "权属状态")
    private Integer qszt;
    @ApiModelProperty(value = "备注")
    private String bz;
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;
    @ApiModelProperty(value = "不动产单元编号")
    private String bdcdywybh;
    @ApiModelProperty(value = "坐落")
    private String zl;
    @ApiModelProperty(value = "不动产权证号")
    private String bdcqzh;
    @ApiModelProperty(value = "异议事项到期天数")
    private int qx;
    @ApiModelProperty(value = "权利人证件号：查询")
    private String[] qlrzjh;
    @ApiModelProperty(value = "权利人证件号:展示")
    private String zjh;
    @ApiModelProperty("原系统产权证号")
    private String yxtcqzh;
    @ApiModelProperty("查询类型")
    private String type;
    @ApiModelProperty("客户端ip")
    private String clientIp;

    public String getYxtcqzh() {
        return yxtcqzh;
    }

    public void setYxtcqzh(String yxtcqzh) {
        this.yxtcqzh = yxtcqzh;
    }

    public String getQlr() {
        return qlr;
    }

    public void setQlr(String qlr) {
        this.qlr = qlr;
    }

    public String getQlid() {
        return qlid;
    }

    public void setQlid(String qlid) {
        this.qlid = qlid;
    }

    public String getYysx() {
        return yysx;
    }

    public void setYysx(String yysx) {
        this.yysx = yysx;
    }

    public String getZxyyywh() {
        return zxyyywh;
    }

    public void setZxyyywh(String zxyyywh) {
        this.zxyyywh = zxyyywh;
    }

    public String getZxyyyy() {
        return zxyyyy;
    }

    public void setZxyyyy(String zxyyyy) {
        this.zxyyyy = zxyyyy;
    }

    public Date getZxyydjsj() {
        return zxyydjsj;
    }

    public void setZxyydjsj(Date zxyydjsj) {
        this.zxyydjsj = zxyydjsj;
    }

    public String getZxyydbr() {
        return zxyydbr;
    }

    public void setZxyydbr(String zxyydbr) {
        this.zxyydbr = zxyydbr;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getDbr() {
        return dbr;
    }

    public void setDbr(String dbr) {
        this.dbr = dbr;
    }

    public String getDjjg() {
        return djjg;
    }

    public void setDjjg(String djjg) {
        this.djjg = djjg;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public Integer getQszt() {
        return qszt;
    }

    public void setQszt(Integer qszt) {
        this.qszt = qszt;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getBdcdywybh() {
        return bdcdywybh;
    }

    public void setBdcdywybh(String bdcdywybh) {
        this.bdcdywybh = bdcdywybh;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public int getQx() {
        return qx;
    }

    public void setQx(int qx) {
        this.qx = qx;
    }

    public String[] getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String[] qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getZjh() {
        return zjh;
    }

    public void setZjh(String zjh) {
        this.zjh = zjh;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    @Override
    public String toString() {
        return "BdcYyVO{" +
                "qlr='" + qlr + '\'' +
                ", qlid='" + qlid + '\'' +
                ", yysx='" + yysx + '\'' +
                ", zxyyywh='" + zxyyywh + '\'' +
                ", zxyyyy='" + zxyyyy + '\'' +
                ", zxyydjsj=" + zxyydjsj +
                ", zxyydbr='" + zxyydbr + '\'' +
                ", slbh='" + slbh + '\'' +
                ", xmid='" + xmid + '\'' +
                ", gyqk='" + gyqk + '\'' +
                ", djsj=" + djsj +
                ", dbr='" + dbr + '\'' +
                ", djjg='" + djjg + '\'' +
                ", fj='" + fj + '\'' +
                ", qszt=" + qszt +
                ", bz='" + bz + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", bdcdywybh='" + bdcdywybh + '\'' +
                ", zl='" + zl + '\'' +
                ", bdcqzh='" + bdcqzh + '\'' +
                ", qx=" + qx +
                ", qlrzjh=" + Arrays.toString(qlrzjh) +
                ", zjh='" + zjh + '\'' +
                ", yxtcqzh='" + yxtcqzh + '\'' +
                ", type='" + type + '\'' +
                '}';
    }
}
