package cn.gtmap.realestate.common.core.support.spring;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * html特殊页面过滤器
 * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
 * @version 1.0  2019/8/16.
 * @description
 */
@Component
@ConfigurationProperties(prefix = "html")
public class TsHtmlFilter {

    private static  final Logger LOGGER = LoggerFactory.getLogger(TsHtmlFilter.class);

    /**
     * 页面版本
     */
    private String version;

    @Bean("htmlFilter")
    public Filter filter (){
        return new Filter() {
            @Override
            public void init(FilterConfig filterConfig) throws ServletException {
                LOGGER.info("html filter init!");
            }

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)  throws IOException, ServletException{
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                String path=httpRequest.getServletPath();
                if(StringUtils.isNotBlank(version) && path.indexOf("/"+version+"/")<0){
                    String tspath=path.replaceFirst("view",version);
                    if(!StringUtils.equals(tspath,path)){
                        Resource resource = new ClassPathResource("/META-INF/resources"+tspath);
                        if(resource.exists()){
                            httpRequest.getRequestDispatcher(tspath).forward(httpRequest,response);
                            return;
                        }
                    }
                }
                chain.doFilter(request,response);
            }

            @Override
            public void destroy() {
            }
        };
    }

    @Bean
    public DelegatingFilterProxyRegistrationBean delegatingFilterProxyRegistrationBean(){
        DelegatingFilterProxyRegistrationBean bean = new DelegatingFilterProxyRegistrationBean("htmlFilter");
        bean.addUrlPatterns("*.html");
        return bean;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}
