package cn.gtmap.realestate.common.core.support.log;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @description 公共日志保存服务
 */
@RestController
@RequestMapping(value = "/rest/v1.0/log")
public class BdcLogInfoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcLogInfoController.class);

    /**
     * 用户服务
     */
    @Autowired
    private UserManagerUtils userManagerUtils;

    /**
     * 日志服务
     */
    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;


    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param logInfoMap 日志参数信息
     * @description  保存日志信息
     *
     *  1、为了灵活直接用 Map 参数，常用 KEY 说明：
     *  >>>>>>>>>>>>>>>>>>>>>>>>>>>
     *   userAlias       用户名称
     *   userName        用户账号
     *   viewTypeName    页面名称
     *   logType         日志类型
     *   response        日志详细内容
     *   cxtj            查询条件
     *   bdcdyh          不动产单元号
     *   xmid            项目ID
     *   zl              坐落
     *   ipaddress       IP地址
     *   slbh            受理编号
     *   ywr             义务人
     *   qlr             权利人
     *  >>>>>>>>>>>>>>>>>>>>>>>>>>>
     *
     *  2、必要 KEY 值项： logType
     */
    @PostMapping(value = "/info")
    public void saveLogInfo(@RequestBody Map<String, Object> logInfoMap) {
        if(MapUtils.isEmpty(logInfoMap) || StringUtils.isBlank(MapUtils.getString(logInfoMap, "logType"))){
            LOGGER.error("保存日志信息中止，因为日志参数信息为空");
            return;
        }

        // 获取用户名称、账号
        String userAlias = MapUtils.getString(logInfoMap, "userAlias");
        String userName = MapUtils.getString(logInfoMap, "userName");

        if(StringUtils.isBlank(userAlias) || StringUtils.isBlank(userName)){
            UserDto userDto = userManagerUtils.getCurrentUser();

            userAlias = userDto == null ? "" : userDto.getAlias();
            logInfoMap.put("alias", userAlias);

            userName = userDto == null ? "" : userDto.getUsername();
            logInfoMap.put("userName", userName);
        }

        try {
            String logType = MapUtils.getString(logInfoMap, "logType");
            zipkinAuditEventRepository.newSpanTag(new AuditEvent(userName, logType, logInfoMap), logType);
        }catch(Exception e){
            LOGGER.error("保存日志信息出错：{}", e.getMessage());
        }
    }
}
