package cn.gtmap.realestate.common.core.service.rest.register;

import cn.gtmap.realestate.common.core.domain.BdcDyaqDO;
import cn.gtmap.realestate.common.core.domain.BdcDysdDO;
import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.dto.BdcPrintDTO;
import cn.gtmap.realestate.common.core.dto.BdcUrlDTO;
import cn.gtmap.realestate.common.core.dto.register.BdcLsgxXmDTO;
import cn.gtmap.realestate.common.core.dto.register.BdcdySumDTO;
import cn.gtmap.realestate.common.core.qo.init.BdcXmQO;
import cn.gtmap.realestate.common.core.qo.register.BdcBdcdyQO;
import cn.gtmap.realestate.common.core.qo.register.BdcLsgxQO;
import cn.gtmap.realestate.common.core.vo.register.ui.BdcBdcdyVO;
import cn.gtmap.realestate.common.core.vo.register.ui.BdcDyawqdVO;
import cn.gtmap.realestate.common.core.vo.register.ui.BdcJfVO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/2/21
 * @description 不动产单元相关服务定义
 */
public interface BdcBdcdyRestService {
    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param   pageable  分页参数
     * @param   bdcLsgxParamJson  查询参数
     * @return {Page} 项目列表
     * @description  查询不动产单元号对应的项目登记历史关系
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy")
    Page<BdcLsgxXmDTO> listBdcdyLsgx(@RequestBody Pageable pageable,
                                     @RequestParam(name = "bdcLsgxParamJson", required = true)String bdcLsgxParamJson);

    /**
     * @param page 页码
     * @param size 每页的数据量
     * @param sort 排序
     * @return Page<BdcXmDO> 分页查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 分页查询项目信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcXmPage", method = RequestMethod.POST)
    Page<BdcXmDO> listXmByPage(@RequestParam(name = "page") int page, @RequestParam(name = "size") int size, @RequestParam(name = "sort", required = false) Sort sort, @RequestBody BdcXmDO bdcXmDO);

    /**
     * @param page 页码
     * @param size 每页的数据量
     * @param sort 排序
     * @return Page<BdcXmDO> 分页查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 分页查询不动产单元信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdyPage", method = RequestMethod.POST)
    Page<BdcBdcdyVO> listBdcdyByPage(@RequestParam(name = "page") int page, @RequestParam(name = "size") int size, @RequestParam(name = "sort", required = false) Sort sort, @RequestBody BdcBdcdyQO bdcBdcdyQO);

    /**
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: pageable 分页参数
     * @param: bdcBdcdyQOJson 不动产单元查询实体类JSON数据
     * @return: Page<BdcBdcdyVO> 分页的不动产单元视图实体类
     * @description 分页查询不动产单元信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdyPage/json", method = RequestMethod.POST)
    Page<BdcBdcdyVO> listBdcdyByPage(Pageable pageable, @RequestParam(name = "bdcBdcdyQOJson", required = false) String bdcBdcdyQOJson);

    /**
     * @param page 页码
     * @param size 每页的数据量
     * @param sort 排序
     * @return Page<BdcXmDO> 分页查询结果
     * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
     * @description 分页查询流程中的不动产单元号和坐落（去重）
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/distinctBdcdyhPage", method = RequestMethod.POST)
    Page<BdcBdcdyVO> listDistinctBdcdyByPage(@RequestParam(name = "page") int page, @RequestParam(name = "size") int size, @RequestParam(name = "sort", required = false) Sort sort, @RequestBody BdcXmDO bdcXmDO);

    /**
     * @param bdcXmDO 项目信息
     * @return List<BdcBdcdyVO> 不动产单元信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 查询不动产单元信息(和分页查询不动产单元信息是同一个查询)
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdy/list", method = RequestMethod.POST)
    List<BdcBdcdyVO> queryBdcdyList(@RequestBody BdcXmDO bdcXmDO);
    /**
     * @param page 页码
     * @param size 每页的数据量
     * @param sort 排序
     * @return Page<BdcXmDO> 分页查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 分页查询抵押物清单
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dyawqdPage", method = RequestMethod.POST)
    Page<BdcDyawqdVO> listDyawqdByPage(@RequestParam(name = "page") int page, @RequestParam(name = "size") int size, @RequestParam(name = "sort", required = false) Sort sort, @RequestBody BdcXmDO bdcXmDO);

    /**
     * @param pageable 每页的数据量
     * @return Page<BdcJfVO> 分页查询结果
     * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
     * @description 分页查询解封清单
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/jfqdPage", method = RequestMethod.GET)
    Page<BdcJfVO> listJfqdByPage(@RequestBody Pageable pageable, @RequestParam(name = "gzlslid") String gzlslid);

    /**
     * @param page 页码
     * @param size 每页的数据量
     * @param sort 排序
     * @param dyabg
     * @return Page<BdcXmDO> 分页查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 分页查询原抵押物清单（用于注销流程的展示查询）
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/ydyawqdPage", method = RequestMethod.POST)
    Page<BdcDyawqdVO> listYxmdyawqdByPage(@RequestParam(name = "page") int page, @RequestParam(name = "size") int size, @RequestParam(name = "sort", required = false) Sort sort, @RequestBody BdcXmDO bdcXmDO, @RequestParam(name = "dyabg", required = false) Integer dyabg);

    /**
     * @param page 页码
     * @param size 每页的数据量
     * @param sort 排序
     * @return Page<BdcXmDO> 分页查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 分页查询抵押注销证明信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dyaZxzmPage", method = RequestMethod.POST)
    Page<BdcXmDO> listDyaZxByPage(@RequestParam(name = "page") int page, @RequestParam(name = "size") int size, @RequestParam(name = "sort", required = false) Sort sort, @RequestBody BdcXmDO bdcXmDO);
    /**
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @param bdcXmQO 查询参数
     * @return List<BdcDyaqDO> 抵押信息
     * @description  查询当前流程的原抵押信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/ydyaxx", method = RequestMethod.POST)
    List<BdcDyaqDO> queryYdyaxx(@RequestBody BdcXmQO bdcXmQO);
    /**
     * @param bdcXmDO 项目信息
     * @return List<BdcDyawqdVO>
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 查询抵押物清单
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/dyawqd", method = RequestMethod.POST)
    List<BdcDyawqdVO> queryDyawqd(@RequestBody BdcXmDO bdcXmDO);

    /**
     * @param bdcXmDO 项目信息
     * @return List<BdcDyawqdVO>
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 查询原抵押物清单信息
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/ydyawqd", method = RequestMethod.POST)
    List<BdcDyawqdVO> queryYxmDyawqd(@RequestBody BdcXmDO bdcXmDO);

    /**
     * @param bdcXmDO 项目信息
     * @return List<BdcDyawqdVO>
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 抵押变更类型1时，查询抵押物清单
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/ydyawqd/bg", method = RequestMethod.POST)
    List<BdcDyawqdVO> queryBgYxmDyawqd(@RequestBody BdcXmDO bdcXmDO);

    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param   bdcdyh  不动产单元号
     * @return {Boolean} 存在查封：true，不存在查封：false
     * @description  判断不动产单元号对应的权利人是否存在查封
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/qlr/cf/{bdcdyh}")
    Boolean isBdcdyhQlrCf(@PathVariable("bdcdyh") String bdcdyh);

    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param   bdcdyh  不动产单元号
     * @return {Boolean} 存在异议：true，不存在异议：false
     * @description  判断不动产单元号对应的权利人是否存在异议
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/qlr/yy/{bdcdyh}")
    Boolean isBdcdyhQlrYy(@PathVariable("bdcdyh") String bdcdyh);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcdyh 不动产单元号
     * @return {List} 锁定则返回提示信息；未锁定则返回空
     * @description 验证所在宗地不动产单元是否锁定
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/{bdcdyh}/zdsd")
    List<String> isZdBdcdySd(@PathVariable("bdcdyh") String bdcdyh);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param xmid 项目ID
     * @return {Boolean} 验证通过：true ；不通过：false
     * @description 验证当前项目权利人权利比例之和是否为1
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/xmxx/qlr/{xmid}")
    Boolean checkQlrQlbl(@PathVariable("xmid")String xmid);

    /**
     * @param gzlslid   工作流实例ID
     * @param dylx      打印类型
     * @param bdcUrlDTO url请求对象
     * @return String  获取打印xml
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 打印xml
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/print/bdcdy/xml", method = RequestMethod.POST)
    String bdcdyPrintXml(@RequestParam(name = "gzlslid") String gzlslid, @RequestParam(name = "dylx") String dylx, @RequestBody BdcUrlDTO bdcUrlDTO);

    /**
     * @param bdcPrintDTO 打印参数
     * @return String  获取打印xml
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 打印xml
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/print/bdcdy/printDTO/xml", method = RequestMethod.POST)
    String bdcdyPrintXml(@RequestBody BdcPrintDTO bdcPrintDTO);
    /**
     * 获取项目来源信息
     * @param xmid
     * @return
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/tellTdFromBdc")
    Map queryXmly(@RequestParam(name = "xmid") String xmid);

    /**
     * @param gzlslid 工作流实例ID
     * @return 面积和
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 计算房地产权面积之和
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/mj/{gzlslid}")
    BdcdySumDTO calculatedFdcqMj(@PathVariable("gzlslid") String gzlslid,@RequestParam(name = "sfyql") Boolean sfyql,@RequestParam(name = "djxl", required = false) String djxl);

    /**
     * @param gzlslid 工作流实例ID
     * @return 面积和
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 计算抵押权面积之和
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/dyaq/mj/{gzlslid}")
    BdcdySumDTO calculatedDyaqMj(@PathVariable("gzlslid") String gzlslid,@RequestParam(name = "sfyql") Boolean sfyql,@RequestParam(name = "djxl", required = false) String djxl,@RequestParam(name = "systemVersion") String systemVersion);

    /**
     * @param gzlslid 工作流实例ID
     * @return 面积和
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @description 计算抵押权面积之和
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/dyaq/mjgybdclx/{gzlslid}")
    List<BdcdySumDTO> calculatedDyaqMjGyBdclx(@PathVariable("gzlslid") String gzlslid,@RequestParam(name = "sfscql")
            Boolean sfscql);

    /**
     * @param bdcdyh
     * @param sdzt
     * @return 锁定数据
     * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     * @description 获取单元号的锁定数据
     */
    @GetMapping(value = "/realestate-register/rest/v1.0/bdcdy/dysd/list")
    List<BdcDysdDO> queryBdcDysd(@RequestParam(value = "bdcdyh") String bdcdyh, @RequestParam(value = "sdzt",required = false)Integer sdzt);

    /**
     * @param gzlslid   工作流实例ID
     * @param bdcDyaqDO 抵押信息
     * @return 更新数据量
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 更新原抵押信息的抵押注销申请人
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/ydyaxx/dyzxsqr/{gzlslid}", method = RequestMethod.POST)
    int saveYdyaxxZxsqrPl(@PathVariable(value = "gzlslid") String gzlslid, @RequestBody BdcDyaqDO bdcDyaqDO);

    /**
     * 查询当前项目上一手的产权
     *
     * @param bdcLsgxQO 历史关系查询对象
     * @return 不动产单元列表
     * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdy/lsgx/last/cq", method = RequestMethod.POST)
    List<BdcLsgxXmDTO> listBdcdyLsgxLastCq(@RequestBody BdcLsgxQO bdcLsgxQO);

    /**
     * 通过上一手的证书信息查询现不动产项目信息
     * <p>不动产项目表，不动产历史关系表，不动产项目证书关系表三表关联查询项目信息</p>
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: [gzlslid, zsid] 工作流实例ID， 证书ID（上一手项目的证书ID）
     * @return: List<BdcXmDO> 不动产项目信息集合
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/bdcdy/lsgx/bdcxm/list", method = RequestMethod.POST)
    List<BdcXmDO> queryBdcXmByGzlslidAndZsid(@RequestParam(value = "gzlslid")String gzlslid,
                                             @RequestParam(value = "zsid", required = false) String zsid);

    /**
     * @param bdcXmQO 项目查询对象
     * @return Page<BdcXmDO> 分页查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取当前项目和原项目的单元信息，并去重
     */
    @RequestMapping(value = "/realestate-register/rest/v1.0/xmOrYxm", method = RequestMethod.POST)
    Page<BdcXmDO> getXmOrYxmDistinctByDyhPage(@RequestParam(name = "page") int page, @RequestParam(name = "size") int size, @RequestParam(name = "sort", required = false) Sort sort, @RequestBody BdcXmQO bdcXmQO);
}
