package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.domain.inquiry.BdcZjDO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
 * @version 1.0, 2020/4/10
 * @description 质检查询相关接口
 */
public interface BdcZjRestService {
    /**
     * 查询质检状态
     *
     * @param kssj
     * @param jssj
     * @return
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/zjcx/queryZjzt")
    Object queryZjzt(@RequestParam("kssj") String kssj, @RequestParam("jssj") String jssj);

    /**
     * 创建质检信息
     *
     * @param kssj
     * @param jssj
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/zjcx/cjzjxx")
    Integer cjzjxx(@RequestParam("kssj") String kssj, @RequestParam("jssj") String jssj);

    /**
     * 更新质检状态
     *
     * @param bdcZjDOList
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/zjcx/zjztgx")
    void zjztgx(@RequestBody List<BdcZjDO> bdcZjDOList);

}
