package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.dto.register.BdcZszmPrintDTO;
import cn.gtmap.realestate.common.core.qo.inquiry.count.BdcZsTjQO;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
 * @version 1.0  2019-07-10
 * @description 日志模块保存打印信息
 */
public interface BdcLogRestService {

    /**
     * 保存打印日志信息
     * @param BdcPrintLogDTOJSON
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdc/Log/savePrintInfo")
    void savaPrintInfo(@RequestParam(name = "BdcPrintLogDTOJSON", required = false) String BdcPrintLogDTOJSON);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcZszmPrintDTO 打印信息
     * @description  保存打印的证书、证明、证明单数量信息
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdc/log/zszm/print")
    boolean saveBdcZszmPrintInfo(@RequestBody BdcZszmPrintDTO bdcZszmPrintDTO);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcZsTjQO 统计参数
     * @description 统计打印的证书、证明、证明单数量信息
     */
    @PostMapping(value = "/realestate-inquiry/rest/v1.0/bdc/log/zszm/print/count")
    Object countZszmPrint(@RequestBody BdcZsTjQO bdcZsTjQO);
}
