package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.dto.inquiry.BdcCfxxDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
 * @version 1.0  2019-07-10
 * @description 查封信息查询
 */
public interface BdcCfxxRestService {

    /**
     * 分页查询查封信息
     *
     * @param pageable
     * @param bdcCfxxQOJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.inquiry.BdcCfxxDTO                                                               ;>
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcCfxx/page")
    Page<BdcCfxxDTO> listBdcCfByPage(@RequestBody Pageable pageable,
                                     @RequestParam(name = "bdcCfxxQOJson", required = false) String bdcCfxxQOJson);

    /**
     * 查询续封信息
     *
     * @param bdcXfxxQOJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.inquiry.BdcCfxxDTO                                                                                                                               ;>
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcXfxx/page")
    List<Map> listBdcXf(@RequestParam(name = "bdcXfxxQOJson", required = false) String bdcXfxxQOJson);

    /**
     * 解封信息
     *
     * @param jfxxQO
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.inquiry.BdcCfxxDTO                                                                                                                               ;>
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcCf/jf")
    void jfBdcCf(@RequestParam(name = "jfxxQO", required = false) String jfxxQO);

    /**
     * 更新查封信息
     *
     * @param jfxxQO
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.inquiry.BdcCfxxDTO                                                                                                                               ;>
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcCf/edit")
    void editBdcCf(@RequestParam(name = "jfxxQO", required = false) String jfxxQO);


    /**
     * 通过bdcdyh查询续封未超期的数量
     * @param bdcdyhs
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcCf/bdcdyhs")
    int queryWdqXfByBdcyhs(@RequestParam(name = "bdcdyhs", required = false) String bdcdyhs,@RequestParam(name = "xmids", required = false) String xmids);
    /**
     * 提供到期查封信息
     *
     * @param bdcCfxxQOJson
     * @return org.springframework.data.domain.Page<cn.gtmap.realestate.common.core.dto.inquiry.BdcCfxxDTO                                                               ;>
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     */
    @GetMapping(value = "/realestate-inquiry/rest/v1.0/bdcCfDq/list")
    Object bdcCfDqList(@RequestBody Pageable pageable, @RequestParam(name = "bdcXfxxQOJson", required = false) String
            bdcCfxxQOJson);

}
