package cn.gtmap.realestate.common.core.service.rest.inquiry;

import cn.gtmap.realestate.common.core.dto.inquiry.BdcQszmDyDTO;
import cn.gtmap.realestate.common.core.dto.inquiry.BdcQszmQO;
import cn.gtmap.realestate.common.core.qo.init.BdcQlrQO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2020/03/02
 * @description （标准版）综合查询证明相关处理逻辑请求服务
 */
public interface BdcBzbZmRestService {
    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcQlrQO  权利人信息
     * @return {String} Redis key
     * @description （标准版）保存有房无房证明打印参数信息
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/zhcx/bzb/yfwfzm")
    String saveBzbYfwfzmXx(@RequestBody BdcQlrQO bdcQlrQO);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param key 权利人信息Redis键
     * @return {String} XML数据
     * @description 获取打印房产证明的XML数据
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/zhcx/bzb/yfwfzm/{key}/xml")
    String getPrintXmlOfZfxx(@PathVariable("key") String key);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcQszmQOList 打印请求参数
     * @return {BdcQszmDyDTO} 缓存的Redis KEY以及查询号信息
     * @description 缓存权属证明参数信息到redis
     */
    @PostMapping("/realestate-inquiry/rest/v1.0/zhcx/bzb/qszm")
    BdcQszmDyDTO saveBdcQszmParamToRedis(@RequestBody List<BdcQszmQO> bdcQszmQOList);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param key redis key
     * @param bdclx 不动产类型
     * @return {String} XML数据
     * @description 获取打印权属证明的XML数据
     */
    @GetMapping("/realestate-inquiry/rest/v1.0/print/zhcx/bzb/qszm/{key}/{bdclx}/xml")
    String getPrintXmlOfQszm(@PathVariable("key") String key, @PathVariable("bdclx") String bdclx);
}
