package cn.gtmap.realestate.common.core.service.rest.init;

import cn.gtmap.realestate.common.core.domain.BdcFctdPpgxDO;
import cn.gtmap.realestate.common.core.domain.BdcXnbdcdyhGxDO;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
 * @version 1.0  2019/2/28.
 * @description 业务初始化系统对外匹配接口
 */
public interface BdcPpRestService {
    /**
     * 通过传入参数进行落宗处理
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param lsdyh 临时单元号
     *@param bdcdyh 不动产单元号
     *@description
     */
    @PostMapping(value = "/init/rest/v1.0/lz/{lsdyh}/{bdcdyh}")
    void lz(@PathVariable(name = "lsdyh") String lsdyh,@PathVariable(name = "bdcdyh") String bdcdyh) throws Exception;

    /**
     * 通过传入参数进行取消落宗处理
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param bdcdyh 不动产单元号
     *@param qxlzxmid 取消落宗的项目ID
     *@description
     */
    @PostMapping(value = "/init/rest/v1.0/qxlz/{bdcdyh}/{qxlzxmid}")
    void qxlz(@PathVariable(name = "bdcdyh") String bdcdyh,@PathVariable(name = "qxlzxmid") String qxlzxmid) throws Exception;

    /**
     * 房产证和土地证进行匹配记录关系
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param fcxmid 房产项目id
     *@param tdxmid 土地项目id
     *@description
     */
    @PostMapping(value = "/init/rest/v1.0/pptd")
    void pptd(@RequestParam(name = "fcxmid") String fcxmid,@RequestParam(name = "tdxmid") String tdxmid) throws Exception;


    /**
     * 取消房产证和土地证匹配关系
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param fcxmid 房产项目id
     *@return
     *@description
     */
    @DeleteMapping(value = "/init/rest/v1.0/qxpptd")
    void qxpptd(@RequestParam(name = "fcxmid") String fcxmid) throws Exception;

    /**
     * 根据房产项目ID去获取匹配关系
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param fcxmid
     *@return List<BdcFctdPpgxDO>（返回多个时存在数据问题，前端判断处理）
     *@description
     */
    @GetMapping(path = "/init/rest/v1.0/ppgx/{fcxmid}")
    List<BdcFctdPpgxDO> queryBdcFctdPpgx(@PathVariable(name = "fcxmid") String fcxmid);

    /**
     * 根据房产项目ID去获取匹配关系
     *@author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     *@param tdxmid
     *@return List<BdcFctdPpgxDO>（返回多个时存在数据问题，前端判断处理）
     *@description
     */
    @GetMapping(path = "/init/rest/v1.0/ppgx/td/{tdxmid}")
    List<BdcFctdPpgxDO> queryBdcFctdPpgxByTdxmid(@PathVariable(name = "tdxmid") String tdxmid);


    /**
     * 根据虚拟单元号项目id去获取虚拟单元号关系
     *@author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
     *@param xndyhxmid
     *@return List<BdcXnbdcdyhGxDO>  多条时存在数据错误
     *@description
     */
    @GetMapping(path = "/init/rest/v1.0/lsh/xndyhgx/{xndyhxmid}")
    List<BdcXnbdcdyhGxDO> queryBdcXnbdcdyhGxByXmid(@PathVariable(name = "xndyhxmid") String xndyhxmid);
}
