package cn.gtmap.realestate.common.core.service.rest.config;

import cn.gtmap.realestate.common.core.domain.BdcXtZsmbPzDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/01/17
 * @description  不动产系统证书模板配置服务接口
 */
public interface BdcXtZsmbPzRestService {

    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param  pageable 分页对象
     * @param  zsmbpzParamJson 查询条件
     * @return {Page} 证书模板配置分页数据
     * @description  查询证书模板配置数据列表
     */
    @GetMapping("/realestate-config/rest/v1.0/zsmbpz")
    Page<BdcXtZsmbPzDO> listBdcXtZsmbPz(@RequestBody Pageable pageable,
                                         @RequestParam(name = "zsmbpzParamJson", required = false) String zsmbpzParamJson);

    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcXtZsmbPzDO 证书模板配置实体
     * @return {Boolean} 正确：true，不正确：false
     * @description 校验证书模板配置SQL是否正确
     */
    @PostMapping("/realestate-config/rest/v1.0/zsmbpz/sql")
    Boolean checkBdcXtZsmbPzSql(@RequestBody BdcXtZsmbPzDO bdcXtZsmbPzDO);

    /**
     * @author  <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param  bdcXtZsbhmbDO 证书模板配置实体
     * @return {int} 操作数据记录数
     * @description  保存证书模板配置配置
     */
    @PutMapping("/realestate-config/rest/v1.0/zsmbpz")
    int saveBdcXtZsmbPz(@RequestBody BdcXtZsmbPzDO bdcXtZsmbPzDO);


    /**
     * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
     * @param bdcXtZsbhmbDOList 证书模板配置集合
     * @return {int} 操作数据记录数
     * @description 删除证书模板配置
     */
    @DeleteMapping("/realestate-config/rest/v1.0/zsmbpz")
    int deleteBdcXtZsmbPz(@RequestBody List<BdcXtZsmbPzDO> bdcXtZsmbPzDOList);
}
