package cn.gtmap.realestate.common.core.service.rest.config;

import cn.gtmap.realestate.common.core.domain.BdcTsywPzDO;
import cn.gtmap.realestate.common.core.domain.BdcTsywZdyzdxDO;
import cn.gtmap.realestate.common.core.dto.config.BdcTsywPzDTO;
import cn.gtmap.realestate.common.core.qo.config.BdcTsywPzQO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2020/3/5
 * @description 不动产YML配置服务接口
 */
public interface BdcTsywPzRestService {

    /**
     * @param pzid 配置ID
     * @return YML配置对象
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据主键获取YML配置
     */
    @GetMapping("/realestate-config/rest/v1.0/ymlpz")
    BdcTsywPzDO queryBdcTsywPzById(@RequestParam(name = "pzid") String pzid);

    /**
     * @param bdcTsywPzQO 不动产YML配置查询QO
     * @return 配置集合
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 查询YML配置
     */
    @PostMapping("/realestate-config/rest/v1.0/list/ymlpz")
    List<BdcTsywPzDO> listBdcTsywPz(@RequestBody BdcTsywPzQO bdcTsywPzQO);

    /**
     * @param bdcTsywPzQOStr 不动产YML配置查询QO
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 分页查询YML配置
     */
    @PostMapping("/realestate-config/rest/v1.0/ymlpz/page")
    Page<BdcTsywPzDO> listBdcTsywPzByPage(@RequestBody Pageable pageable, @RequestParam(name = "bdcTsywPzQOStr", required = false) String bdcTsywPzQOStr);

    /**
     * @param bdcTsywPzDO 更新YML配置信息
     * @return 更新数量
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据主键更新YM配置信息
     */
    @PutMapping("/realestate-config/rest/v1.0/ymlpz")
    int updateBdcTsywPz(@RequestBody BdcTsywPzDO bdcTsywPzDO);

    /**
     * @param bdcTsywPzDO YML配置信息
     * @return YML配置
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 新增YML配置信息
     */
    @PostMapping("/realestate-config/rest/v1.0/ymlpz")
    BdcTsywPzDO insertBdcTsywPz(@RequestBody BdcTsywPzDO bdcTsywPzDO);

    /**
     * @return 所有YML配置
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 获取所有YML配置,并将配置名称和配置值作为map的key和value
     */
    @GetMapping("/realestate-config/rest/v1.0/ymlpz/all")
    Map<String, String> listAllBdcTsywPz();

    /**
     * @param pzmc 配置名称
     * @return 配置值字符串
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  根据配置名称获取配置值字符串
     */
    @GetMapping("/realestate-config/rest/v1.0/ymlpz/pzz/{pzmc}")
    String getStringValueOfTsywPzz(@PathVariable(name = "pzmc") String pzmc);

    /**
     * @param pzmc 配置名称
     * @return 配置值字符串
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  根据配置名称获取配置值列表List
     */
    @GetMapping("/realestate-config/rest/v1.0/ymlpz/pzz/list/{pzmc}")
    List<String> getListValueOfTsywPzz(@PathVariable(name = "pzmc") String pzmc);

    /**
     * @param pzmc 配置名称
     * @return 配置值字符串
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  根据配置名称获取配置值布尔型
     */
    @GetMapping("/realestate-config/rest/v1.0/ymlpz/pzz/boolean/{pzmc}")
    boolean getBooleanValueOfTsywPzz(@PathVariable(name = "pzmc") String pzmc);

    /**
     * @param pzmc 配置名称
     * @return 配置值字符串
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  根据配置名称获取配置值数组字符串
     */
    @GetMapping("/realestate-config/rest/v1.0/ymlpz/pzz/hash/{pzmc}")
    Map<String, String> getHashValueOfTsywPzz(@PathVariable(name = "pzmc") String pzmc);

    /**
     * @param bdcTsywZdyzdxDO 查询对象
     * @return 自定义字典项
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 查询配置自定义字典项
     */
    @PostMapping("/realestate-config/rest/v1.0/ymlpz/zdyzdx")
    List<BdcTsywZdyzdxDO> listZdyzdx(@RequestBody BdcTsywZdyzdxDO bdcTsywZdyzdxDO);


    /**
     * 获取redis中缓存的各个模块的配置内容，将配置内容持久化至数据库
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @return: void
     */
    @PostMapping("/realestate-config/rest/v1.0/ymlpz/init")
    void initYmlData();

    /**
     * @param pzid 配置ID
     * @return 特殊业务配置DTO
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 通过pzid获取特殊业务配置DTO
     */
    @GetMapping("/realestate-config/rest/v1.0/tsywpz/{pzid}")
    BdcTsywPzDTO queryBdcTsywPzDTO(@PathVariable("pzid") String pzid);

    /**
     * @param bdcTsywPzDTO
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 保存特殊业务配置DTO
     */
    @PostMapping("/realestate-config/rest/v1.0/tsywpz/dto")
    String saveBdcTsywPzDTO(@RequestBody BdcTsywPzDTO bdcTsywPzDTO);

    /**
     * @param bdcTsywPzDO 当前配置项
     * @return 其他配置项
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据字典项标识获取当前配置项以外的配置项
     */
    @PostMapping("/realestate-config/rest/v1.0/tsywpz/list/otherByZdxbs")
    List<BdcTsywPzDO> listOtherTsywPzByZdxbs(@RequestBody BdcTsywPzDO bdcTsywPzDO);


}
