package cn.gtmap.realestate.common.core.service.rest.certificate;

import cn.gtmap.realestate.common.core.domain.certificate.BdcYzhsymxDO;
import cn.gtmap.realestate.common.core.dto.BdcYzxxDTO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcYzhDTO;
import cn.gtmap.realestate.common.core.qo.certificate.BdcYzhQO;
import cn.gtmap.realestate.common.core.qo.certificate.BdcYzhSyqkQO;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * *
 *
 * @author <a href="mailto:zhangwentao@gtmap.cn>zhangwentao</a>"
 * @version 1.0, 2018/12/4
 * @description 不动产印制号
 */
public interface BdcYzhRestService {

    /**
     * @param yzhid 印制号主键
     * @return BdcYzhDTO 返回印制号DTO
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 主键获取印制号
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yzh/{yzhid}", method = RequestMethod.GET)
    BdcYzhDTO queryBdcYzh(@PathVariable(name = "yzhid") String yzhid);

    /**
     * @param zsid     证书ID
     * @param bdcYzhQO 印制号查询QO
     * @return BdcYzhDTO> 印制号DTO对象
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 为证书获取印制号并更新到证书
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/{zsid}/yzh", method = RequestMethod.POST)
    BdcYzhDTO queryBdcZsYzh(@PathVariable(name = "zsid") String zsid, @RequestBody BdcYzhQO bdcYzhQO);

    /**
     * @param bdcYzhQOList 印制号查询QOList
     * @return List<BdcYzhDTO> 获取结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 证书批量获取印制号
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yzh/batchZs", method = RequestMethod.POST)
    List<BdcYzhDTO> queryBatchZsYzh(@RequestBody List<BdcYzhQO> bdcYzhQOList);

    /**
     * @param num      需要获取的印制号的数量
     * @param bdcYzhQO 印制号查询参数
     * @return List<BdcYzhDTO> 返回印制号信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取所需数量的印制号, 数量以路径参数num为主
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yzh/{num}", method = RequestMethod.POST)
    List<BdcYzhDTO> queryBatchYzh(@PathVariable(name = "num") int num, @RequestBody BdcYzhQO bdcYzhQO);

    /**
     * @param bdcYzhQO 印制号查询对象
     * @return List<BdcYzhDTO> 返回印制号DTOList
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 条件查询印制号
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yzh", method = RequestMethod.POST)
    List<BdcYzhDTO> queryListBdcYzh(@RequestBody BdcYzhQO bdcYzhQO);

    /**
     * @param bdcYzhSyqkQO 不动产印制号使用情况QO
     * @return BdcYzhsymxDO 生成的印制号使用明细
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 更新不动产印制号使用情况, 生成印制号使用明细
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yzh", method = RequestMethod.PATCH)
    BdcYzhsymxDO updateBdcYzhSyqk(@RequestBody BdcYzhSyqkQO bdcYzhSyqkQO);

    /**
     * @param bdcYzhSyqkQO 不动产印制号使用情况QO
     * @return BdcYzhsymxDO 生成的印制号使用明细
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 还原被手动修改的印制号信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/revertYzhAndSyqk", method = RequestMethod.PATCH)
    Integer revertYzhAndSyqk(@RequestBody BdcYzhSyqkQO bdcYzhSyqkQO);

    /**
     * @param bdcYzhQO 印制号查询QO
     * @return BdcGzyzTsxxDTO 验证提示信息
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 验证印制号是否可用
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yzh/yzxx", method = RequestMethod.POST)
    BdcYzxxDTO queryYzhYzxx(@RequestBody BdcYzhQO bdcYzhQO);
}
