package cn.gtmap.realestate.common.core.service.rest.certificate;

import cn.gtmap.realestate.common.core.domain.BdcXmYjdGxDO;
import cn.gtmap.realestate.common.core.domain.BdcYjdDO;
import cn.gtmap.realestate.common.core.dto.BdcUrlDTO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcXmYjdDTO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcYjdDTO;
import cn.gtmap.realestate.common.core.dto.certificate.BdcYjdGdxxDTO;
import cn.gtmap.realestate.common.core.qo.certificate.BdcYjdQO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * *
 *
 * @author <a href="mailto:zhangwentao@gtmap.cn>zhangwentao</a>"
 * @version 1.0, 2019/3/1
 * @description 移交单服务
 */
public interface BdcYjdRestService {
    /**
     * @return 移交单编号
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 生成移交单编号
     * @param bdcYjdQO
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd/yjdbh", method = RequestMethod.POST)
    BdcYjdDO generateYjdBh(@RequestBody BdcYjdQO bdcYjdQO);

    /**
     * @param bdcYjdQO 移交单查询QO
     * @return BdcYjdDO
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 生成并保存移交单信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd/yjdxx", method = RequestMethod.POST)
    BdcYjdDO generateAndSaveYjdxx(@RequestBody BdcYjdQO bdcYjdQO);

    /**
     * @param bdcYjdDO 移交单DO
     * @return 更新结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 更新移交单信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd", method = RequestMethod.PUT)
    int updateBdcYjd(@RequestBody BdcYjdDO bdcYjdDO);
    /**
     * @param bdcXmYjdGxDOList 项目移交单关系列表
     * @return 更新结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 批量更新项目移交单关系
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd/xmYjdGx", method = RequestMethod.PUT)
    int updateXmYjdGx(List<BdcXmYjdGxDO> bdcXmYjdGxDOList);

    /**
     * @param pageable 分页对象
     * @param bdcYjdQO 移交单查询对象
     * @return 分页查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 分页查询移交单移交移交单内容
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd/page", method = RequestMethod.POST)
    Page<BdcYjdDTO> listBdcYjdByPage(@RequestBody Pageable pageable, @RequestParam(name = "bdcYjdQO", required = false) String bdcYjdQO);

    /**
     * @param bdcYjdQO 移交单查询QO
     * @return 查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 移交单包含项目信息查询
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd/list", method = RequestMethod.POST)
    List<BdcYjdDTO> listYjdAndXm(@RequestBody BdcYjdQO bdcYjdQO);

    /**
     * @param bdcYjdQO 移交单查询QO
     * @return 查询结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 查询拥有移交单的项目
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd/xmYjdList", method = RequestMethod.POST)
    List<BdcXmYjdDTO> listXmOwnYjd(@RequestBody BdcYjdQO bdcYjdQO);

    /**
     * @param yjdid 移交单ID
     * @param dylx
     * @param bdcUrlDTO 地址对象
     * @return 打印xml字符串
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取移交单的打印xml
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd/print/{yjdid}/{dylx}/xml", method = RequestMethod.POST)
    String yjdPrintXml(@PathVariable(name = "yjdid") String yjdid, @PathVariable(name = "dylx") String dylx, @RequestBody BdcUrlDTO bdcUrlDTO);


    /**
     * @param pageable 分页对象
     * @return 分页查询结果
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @description 分页查询移交单核验归档信息
     */
    @RequestMapping(value = "/realestate-certificate/rest/v1.0/yjd/checkYjd/yjdid", method = RequestMethod.POST)
    Page<BdcYjdGdxxDTO> listBdcYjdGdxx(@RequestBody Pageable pageable,@RequestParam(name = "bdcYjdQO", required = false) String bdcYjdQO);

    /**
     * @param gxid 关系id
     * @return 删除归档信息
     * @author <a href="mailto:chenyucheng@gtmap.cn">chenyucheng</a>
     * @description 删除归档信息
     */
    @DeleteMapping(value = "/realestate-certificate/rest/v1.0/yjd/delGdxx/gxid")
    void delGdxx(@RequestParam(name = "gxid", required = false) String gxid);

}
