package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.domain.building.ZhDjdcbDO;
import cn.gtmap.realestate.common.core.domain.building.ZhQlrDO;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0  2018/11/14
 * @description 宗海相关服务
 */
public interface ZhRestService {

    /**
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.domain.building.BdcDjsjDO
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据不动产单元号查询宗海地籍数据
     */
    @GetMapping("/building/rest/v1.0/zh/{bdcdyh}")
    ZhDjdcbDO queryZhByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);


    /**
     * @param bdcdyh
     * @return java.util.List<cn.gtmap.realestate.common.core.domain.building.ZhQlrDo>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据BDCDYH查询宗海权利人信息
     */
    @GetMapping("/building/rest/v1.0/zh/qlr/{bdcdyh}")
    List<ZhQlrDO> listZhQlrByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);

}
