package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.domain.building.ZdDjdcbDO;
import cn.gtmap.realestate.common.core.domain.building.ZdQlrDO;
import cn.gtmap.realestate.common.core.dto.building.DjdcbJzxxResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.ZdResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.ZdTreeResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.ZdtResponseDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0  2018/11/8
 * @description 宗地相关服务
 */
public interface ZdRestService {
    /**
     * @param pageable
     * @param paramJson
     * @return Page<Map>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 分页查询宗地信息
     */
    @PostMapping("/building/rest/v1.0/zd/page")
    Page<Map> listZdByPageJson(@RequestBody Pageable pageable,
                               @RequestParam(name = "paramJson", required = false) String paramJson);

    /**
     * @param fwDcbIndex
     * @return cn.gtmap.realestate.common.core.dto.building.ZdTreeResponseDTO
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 根据逻辑幢主键初始化宗地目录树 包括宗地 和 宗地下的自然幢列表
     */
    @GetMapping("/building/rest/v1.0/zd/tree/{fwDcbIndex}")
    ZdTreeResponseDTO initZdTreeByFwDcbIndex(@PathVariable("fwDcbIndex") String fwDcbIndex);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param djh
     * @return cn.gtmap.realestate.common.core.dto.building.ZdTreeResponseDTO
     * @description 根据地籍号初始化宗地目录树(自然幢列表来源于FW_LJZ)
     */
    @GetMapping("/building/rest/v1.0/zd/tree/djh/{djh}")
    ZdTreeResponseDTO initZdTreeByDjhAndAllZrzh(@PathVariable("djh") String djh);

    /**
     * @param fwDcbIndex
     * @return cn.gtmap.realestate.common.core.dto.building.ZdTreeResponseDTO
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 根据逻辑幢主键初始化宗地目录树 包括宗地 和 宗地下的自然幢列表
     */
    @GetMapping("/building/rest/v1.0/zd/tree/{fwDcbIndex}/withallzrz")
    ZdTreeResponseDTO initZdTreeByFwDcbIndexAndAllZrzh(@PathVariable("fwDcbIndex") String fwDcbIndex);

    /**
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.domain.building.BdcDjsjDO
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据不动产单元号查询宗地地籍数据
     */
    @GetMapping("/building/rest/v1.0/zd/{bdcdyh}")
    ZdDjdcbDO queryZdByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);

    /**
     * @param bdcdyh
     * @return java.util.List<cn.gtmap.realestate.common.core.domain.building.ZdQlrDO>
     * @author <a href="mailto:xiayuqing@gtmap.cn">xiayuqing</a>
     * @description
     */
    @GetMapping("/building/rest/v1.0/zd/qlr/{bdcdyh}")
    List<ZdQlrDO> listZdQlrByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param djh
     * @return cn.gtmap.realestate.common.core.domain.building.ZdDjdcbDO
     * @description  根据地籍号查询宗地地籍数据
     */
    @GetMapping("/building/rest/v1.0/zd/djh/{djh}")
    ZdDjdcbDO queryZdByDjh(@PathVariable("djh") String djh);

    /**
     * @param pageable
     * @param paramJson
     * @return Page<Map>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 分页查询宗地界址信息信息
     */
    @PostMapping("/building/rest/v1.0/zdjzxx/page")
    Page<DjdcbJzxxResponseDTO> listZdjzxxByPageJson(@RequestBody Pageable pageable,
                                                    @RequestParam(name = "paramJson", required = false) String paramJson);

    /**
     * @param djh
     * @return List<String>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据地籍号查询有效的不动产单元号
     */
    @PostMapping("/building/rest/v1.0/zd/validbdcdyh/djh")
    List<String> listValidBdcdyhByDjh(@RequestParam(value = "djh", required = false) String djh);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param djh
     * @return java.lang.String
     * @description 根据DJH查询宗地图 JPG
     */
    @GetMapping("/building/rest/v1.0/zd/zdt/{djh}")
    ZdtResponseDTO queryZdtByDjh(@PathVariable(name = "djh") String djh);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcdyh
     * @return java.lang.String
     * @description 根据bdcdyh查询宗地图 JPG
     */
    @GetMapping("/building/rest/v1.0/zd/zdt/bdcdyh/{bdcdyh}")
    ZdtResponseDTO queryZdtByBdcdyh(@PathVariable(name = "bdcdyh") String bdcdyh);

    /**
     * @param djh
     * @return java.lang.String
     * @author <a href="mailto:liyinqiao@gtmap.cn">wangzijie</a>
     * @description 根据DJH查询宗地图文档中心ID

    @GetMapping("/building/rest/v1.0/zd/zdtid/{djh}")
    String queryZdtIDByDjh(@PathVariable(name = "djh") String djh) throws IOException;*/
}
