package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.domain.building.QszdDjdcbDO;
import cn.gtmap.realestate.common.core.domain.building.QszdQlrDO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0  2018/11/13
 * @description 权属宗地相关服务
 */
public interface QszdRestService {
    /**
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.domain.building.BdcDjsjDO
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据BDCDYH查询权属宗地基本信息
     */
    @GetMapping("/building/rest/v1.0/qszd/{bdcdyh}")
    QszdDjdcbDO queryQszdByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);

    /**
     * @param bdcdyh
     * @return java.util.List<cn.gtmap.realestate.common.core.domain.building.QszdQlrDO>
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @description 根据不动产单元号查询权属宗地权利人
     */
    @GetMapping("/building/rest/v1.0/qszd/qlr/{bdcdyh}")
    List<QszdQlrDO> listQszdQlrByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);
}
