package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.domain.building.FwHsDO;
import cn.gtmap.realestate.common.core.domain.building.FwHstDO;
import cn.gtmap.realestate.common.core.dto.building.FwHstRequestDTO;
import org.springframework.security.access.method.P;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0  2018-11-08
 * @description 房屋户室图相关服务
 */
public interface FwHstRestService {

    /**
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @param fwHstIndex
     * @return cn.gtmap.realestate.common.core.domain.building.FwHsDO
     * @description 删除户室图服务
     */
    @DeleteMapping("/building/rest/v1.0/hst/{fwHstIndex}")
    Integer deleteFwHstByFwHstIndex(@PathVariable("fwHstIndex") String fwHstIndex);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwHsIndex
     * @return void
     * @description 删除户室的户室图
     */
    @DeleteMapping("/building/rest/v1.0/hst/delfwhshst/{fwHsIndex}/{hslx}")
    void delFwhsHst(@PathVariable("fwHsIndex") String fwHsIndex,@PathVariable("hslx") String hslx);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwDcbIndex
     * @return void
     * @description 删除独幢平面图
     */
    @DeleteMapping("/building/rest/v1.0/hst/delfwljzpmt/{fwDcbIndex}")
    void delFwLjzPmt(@PathVariable("fwDcbIndex") String fwDcbIndex);

    /**
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @param fwDcbIndex
     * @return cn.gtmap.realestate.common.core.domain.building.FwHsDO
     * @description 查看逻辑幢下户室图缺失情况
     */
    @GetMapping("/building/rest/v1.0/hst/deficiency/{fwDcbIndex}")
    List<FwHsDO> listHstDeficiency(@PathVariable("fwDcbIndex") String fwDcbIndex);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwHstRequestDTO
     * @return void
     * @description 户室图请求实体
     */
    @PutMapping("/building/rest/v1.0/hst")
    FwHstDO saveHst(@RequestBody FwHstRequestDTO fwHstRequestDTO);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwHstRequestDTO
     * @return cn.gtmap.realestate.common.core.domain.building.FwHstDO
     * @description 保存幢平面图
     */
    @PutMapping("/building/rest/v1.0/hst/pmt")
    FwHstDO saveLjzPmt(@RequestBody FwHstRequestDTO fwHstRequestDTO);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwHstIndex
     * @return cn.gtmap.realestate.common.core.domain.building.FwHstDO
     * @description 根据主键查询户室图
     */
    @GetMapping("/building/rest/v1.0/hst/{fwHstIndex}")
    FwHstDO queryHstByIndex(@PathVariable("fwHstIndex") String fwHstIndex);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwDcbIndex
     * @return java.lang.String
     * @description  查询 逻辑幢平面图 base64位码
     */
    @GetMapping("/building/rest/v1.0/hst/pmt/base64/{fwDcbIndex}")
    String queryLjzPmtBase64(@PathVariable(name = "fwDcbIndex") String fwDcbIndex);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param fwHsIndex
     * @return java.lang.String
     * @description 查询户室图 base64位码
     */
    @GetMapping("/building/rest/v1.0/hst/base64/{fwHsIndex}")
    String queryFwHstBase64(@PathVariable(name = "fwHsIndex")String fwHsIndex);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcdyh
     * @return java.lang.String
     * @description 根据BDCDYH 查询房屋户室图
     */
    @GetMapping("/building/rest/v1.0/hst/base64bybdcdyh/{bdcdyh}")
    String queryFwHstBase64ByBdcdyh(@PathVariable(name = "bdcdyh")String bdcdyh);
}
