package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.dto.building.DjDcbAndQlrResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.DjDcbResponseDTO;
import cn.gtmap.realestate.common.core.dto.building.DjxxResponseDTO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2018-11-17
 * @description 地籍信息相关服务
 */
public interface DjxxRestService {

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.dto.building.DjxxResponseDTO
     * @description 根据BDCDYH查询地籍信息 包含DJDCB、DCB、权利人
     */
    @GetMapping("/building/rest/v1.0/djxx/{bdcdyh}")
    DjxxResponseDTO queryDjxxByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.dto.building.DjxxResponseDTO
     * @description 根据BDCDYH查询地籍信息 包含DJDCB、DCB、权利人
     */
    @GetMapping("/building/rest/v1.0/hdjxx/{bdcdyh}")
    DjxxResponseDTO queryHDjxxByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.dto.building.DjDcbResponseDTO
     * @description 根据BDCDYH查询土地地籍调查表
     */
    @GetMapping("/building/rest/v1.0/djxx/djdcb/{bdcdyh}")
    DjDcbResponseDTO queryDjDcbByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);

    /**
     * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.dto.building.DjDcbAndQlrResponseDTO
     * @description 根据BDCDYH查询地籍信息 包含DJDCB、权利人
     */
    @GetMapping("/building/rest/v1.0/djxx/djdcbwithqlr/{bdcdyh}")
    DjDcbAndQlrResponseDTO getDjdcbAndQlrByBdcdyh(@PathVariable("bdcdyh") String bdcdyh);
}
