package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.domain.building.FwLjzDO;
import cn.gtmap.realestate.common.core.dto.building.BdcdyLcztResponseDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2019-01-23
 * @description 为受理子系统提供
 * 根据BDCLX分页查询BDCDY服务
 */
public interface AcceptBdcdyRestService {

    /**
     * @param pageable
     * @param qlxzAndZdtzm 权利性质及宗地特征码（BDCDYH 的 第13+14位） 多个用,隔开
     * @param zdtzm 宗地特征码(BDCDYH 的 第14位) 多个用,隔开
     * @param dzwtzm 定着物特征码(BDCDYH 的 第20位) 多个用,隔开
     * @param fwlx 判断查询类型 xmxx ljz hs ychs，空为全部
     * @param paramJson
     * @return Page<Map>
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 分页查询土地及定着物类型不动产单元信息
     */
    @PostMapping("/building/rest/v1.0/accept/bdcdy/tddzwbypage")
    Page<Map> listTdAndDzwBdcdyByPage(@RequestBody Pageable pageable,
                                @RequestParam(name = "qlxzAndZdtzm",required = false) String qlxzAndZdtzm,
                                @RequestParam(name = "zdtzm",required = false) String zdtzm,
                                @RequestParam(name = "dzwtzm") String dzwtzm,
                                @RequestParam(name = "fwlx",required = false) String fwlx,
                                @RequestParam(name = "paramJson",required = false) String paramJson);

    /**
     * @param qlxzAndZdtzm 权利性质及宗地特征码（BDCDYH 的 第13+14位） 多个用,隔开
     * @param zdtzm 宗地特征码(BDCDYH 的 第14位) 多个用,隔开
     * @param dzwtzm 定着物特征码(BDCDYH 的 第20位) 多个用,隔开
     * @param fwlx 判断查询类型 xmxx ljz hs ychs，空为全部
     * @param paramJson
     * @return Page<Map>
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @description 不分页查询土地及定着物类型不动产单元信息
     */
    @PostMapping("/building/rest/v1.0/accept/bdcdy/tddzw")
    List<Map> listTdAndDzwBdcdy(@RequestParam(name = "qlxzAndZdtzm",required = false) String qlxzAndZdtzm,
                                @RequestParam(name = "zdtzm",required = false) String zdtzm,
                                @RequestParam(name = "dzwtzm") String dzwtzm,
                                @RequestParam(name = "fwlx",required = false) String fwlx,
                                @RequestParam(name = "paramJson",required = false) String paramJson);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param pageable
     * @param zdtzm
     * @param dzwtzm
     * @param paramJson
     * @return org.springframework.data.domain.Page<java.util.Map>
     * @description 分页查询海域不动产单元信息
     */
    @PostMapping("/building/rest/v1.0/accept/bdcdy/hybypage")
    Page<Map> listHyBdcdyByPage(@RequestBody Pageable pageable,
                                   @RequestParam(name = "zdtzm",required = false) String zdtzm,
                                   @RequestParam(name = "dzwtzm",required = false) String dzwtzm,
                                   @RequestParam(name = "paramJson",required = false) String paramJson);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param zdtzm
     * @param dzwtzm
     * @param paramJson
     * @return org.springframework.data.domain.Page<java.util.Map>
     * @description 不分页查询海域不动产单元信息
     */
    @PostMapping("/building/rest/v1.0/accept/bdcdy/hy")
    List<Map> listHyBdcdy(@RequestParam(name = "zdtzm",required = false) String zdtzm,
                                @RequestParam(name = "dzwtzm",required = false) String dzwtzm,
                                @RequestParam(name = "paramJson",required = false) String paramJson);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param pageable
     * @param zdtzm
     * @param dzwtzm
     * @param paramJson
     * @return org.springframework.data.domain.Page<java.util.Map>
     * @description 分页查询构筑物不动产单元信息
     */
    @PostMapping("/building/rest/v1.0/accept/bdcdy/gzwbypage")
    Page<Map> listGzwBdcdyByPage(@RequestBody Pageable pageable,
                                 @RequestParam(name = "zdtzm",required = false) String zdtzm,
                                 @RequestParam(name = "dzwtzm",required = false) String dzwtzm,
                                 @RequestParam(name = "paramJson",required = false) String paramJson);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param zdtzm
     * @param dzwtzm
     * @param paramJson
     * @return org.springframework.data.domain.Page<java.util.Map>
     * @description 不分页查询构筑物不动产单元信息
     */
    @PostMapping("/building/rest/v1.0/accept/bdcdy/gzw")
    List<Map> listGzwBdcdy(@RequestParam(name = "zdtzm",required = false) String zdtzm,
                                 @RequestParam(name = "dzwtzm",required = false) String dzwtzm,
                                 @RequestParam(name = "paramJson",required = false) String paramJson);


    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param bdcdyh
     * @return cn.gtmap.realestate.common.core.dto.building.BdcdyLcztResponseDTO
     * @description 根据BDCDYH查询流程状态
     */
    @GetMapping("/building/rest/v1.0/accept/bdcdylczt/{bdcdyh}")
    BdcdyLcztResponseDTO queryBdcdyLczt(@PathVariable(name = "bdcdyh") String bdcdyh);

    /**
     * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
     * @param gzlslid
     * @return java.util.List<cn.gtmap.realestate.common.core.domain.building.FwLjzDO>
     * @description 根据工作流实例ID查询当前项目下的所有房屋逻辑幢
     */
    @GetMapping("/building/rest/v1.0/accept/listljzbygzlslid/{gzlslid}")
    List<FwLjzDO> listFwLjzByGzlslid(@PathVariable(name = "gzlslid") String gzlslid);
}
