package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlHsxxDO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSfSsxxDTO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSwxxDTO;
import cn.gtmap.realestate.common.core.dto.accept.TsswDataDTO;
import cn.gtmap.realestate.common.core.dto.exchange.swxx.QuerySwxxResponseDTO;
import cn.gtmap.realestate.common.core.qo.accept.TsswDataQO;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2019/6/24
 * @description 税务信息rest服务
 */
public interface BdcSwRestService {

    /**
     * @param gzlslid 工作流实例ID
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 税务存量房信息推送
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/tsclfswxx/{gzlslid}")
    Object tsClfSwxx(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 税务商品房信息推送
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/tsspfswxx/{gzlslid}")
    Object tsSpfSwxx(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param xmid 项目ID
     * @param slbh 受理编号
     * @param gxlx 更新类型 1：先删除原有税务信息，重新插入税务信息 2.根据纳税人识别号更新核税信息
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  税务信息查询
     */
    @GetMapping("/realestate-accept/rest/v1.0/sw/getswxx/{xmid}/{slbh}")
    QuerySwxxResponseDTO getSwxx(@PathVariable(value = "xmid") String xmid, @PathVariable(value = "slbh")String slbh,@RequestParam(value = "gxlx") String gxlx);

    /**
     * @param xmid 项目ID
     * @param slbh 受理编号
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  税务申报取消作废
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/zfswxx/{xmid}/{slbh}")
    Object qxzfSwxx(@PathVariable(value = "xmid") String xmid,@PathVariable(value = "slbh")String slbh);

    /**
     * @param gzlslid 工作流实例ID
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  根据工作流实例ID税务申报取消作废
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/zfLcswxx/{processInsId}")
    Object qxzfLcSwxx(@PathVariable(value = "processInsId") String gzlslid);

    /**
     * @param htbh 合同编号
     * @param wszt 完税状态
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据合同编号更新完税状态
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/{htbh}/{wszt}")
    Map updateWsztByHtbh(@PathVariable(value = "htbh") String htbh,@PathVariable(value = "wszt") String wszt);

    /**
     * @param gzlslid 工作流实例ID
     * @return 完税状态
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 验证是否完税
     */
    @GetMapping("/realestate-accept/rest/v1.0/sw/wszt/{gzlslid}")
    Boolean checkSfwsByGzlslid(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @return QuerySwxxResponseDTO
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 商品房完税状态
     */
    @GetMapping("/realestate-accept/rest/v1.0/sw/spfwszt/{gzlslid}")
    @Deprecated
    List<QuerySwxxResponseDTO> querySpfwszt(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param bdcXmDO 不动产项目DO
     * @param gxlx 更新类型 1：先删除原有税务信息，重新插入税务信息 2.根据纳税人识别号更新核税信息 3有值更新无值插入
     * @return QuerySwxxResponseDTO
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 商品房完税状态
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/spfwszt")
    QuerySwxxResponseDTO getSpfXmWszt(@RequestBody BdcXmDO bdcXmDO,@RequestParam(value = "gxlx") String gxlx);

    /**
     * @param gzlslid 工作流实例ID
     * @return String 最终结果
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 获取税务三要素核税信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/swsys")
    String getSwsysHsxx(@RequestParam(value = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @return Boolean 建行订单查询并缴库入库
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 建行订单查询并缴库入库
     */
    @GetMapping("/realestate-accept/rest/v1.0/sw/yhddcx/jkrk")
    Object yhddcxAndJkrk(@RequestParam(value = "gzlslid") String gzlslid);

    /**
     * @param bdcSfSsxxDTO 工作流实例ID
     * @return Boolean 建行缴库入库
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 建行缴库入库
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/jkrk")
    Object yhjkrk(@RequestBody BdcSfSsxxDTO bdcSfSsxxDTO);

    /**
     * @param tsswDataQO
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据查询参数提供税务所需信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/gettsswxx")
    TsswDataDTO getTsswDataDTO(@RequestBody TsswDataQO tsswDataQO);

    /**
     * @param bdcSwxxDTOList 税务信息
     * @param htbh 合同编号
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  根据合同编号保存税务信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/saveSwxxDTO")
    void saveSwxxDTOByHtbh(@RequestBody List<BdcSwxxDTO> bdcSwxxDTOList,@RequestParam(value = "htbh") String htbh);

    /**
     * @param slbh 受理编号
     * @param bdcSlHsxxDOList 需要更新的税务信息集合
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据受理编号更新税务三要素
     */
    @PostMapping("/realestate-accept/rest/v1.0/sw/updateSwsys")
    void updateSwsysByNsrbhAndSlbh(@RequestBody List<BdcSlHsxxDO> bdcSlHsxxDOList, @RequestParam(value = "slbh") String slbh);
}
