package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.BdcQl;
import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlXmDO;
import cn.gtmap.realestate.common.core.dto.accept.BdcCshSlxmDTO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlYwxxDTO;
import cn.gtmap.realestate.common.core.dto.accept.YxBdcdyDTO;
import cn.gtmap.realestate.common.core.qo.accept.BdcSlXmQO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/11/12
 * @description 不动产受理项目rest服务
 */
public interface BdcSlXmRestService {
    /**
     * @param xmid 项目ID
     * @return 不动产受理项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据项目ID获取不动产受理项目
     */
    @GetMapping("/realestate-accept/rest/v1.0/xm/{xmid}")
    BdcSlXmDO queryBdcSlXmByXmid(@PathVariable(value = "xmid") String xmid);

    /**
     * @param jbxxid 基本信息ID
     * @return 不动产受理项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据基本信息ID获取不动产受理项目
     */
    @GetMapping("/realestate-accept/rest/v1.0/xm/list/{jbxxid}")
    List<BdcSlXmDO> listBdcSlXmByJbxxid(@PathVariable(value = "jbxxid") String jbxxid);

    /**
     * @param gzlslid 工作流实例ID
     * @return 不动产受理项目
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据工作流实例ID获取不动产受理项目
     */
    @GetMapping("/realestate-accept/rest/v1.0/xm/list/gzlslid/{gzlslid}")
    List<BdcSlXmDO> listBdcSlXmByGzlslid(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param bdcSlXmDO 不动产受理项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 新增不动产受理项目
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/")
    BdcSlXmDO insertBdcSlXm(@RequestBody BdcSlXmDO bdcSlXmDO);

    /**
     * @param bdcSlXmDO 不动产受理项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 更新不动产受理项目
     */
    @PutMapping("/realestate-accept/rest/v1.0/xm/")
    Integer updateBdcSlXm(@RequestBody BdcSlXmDO bdcSlXmDO);

    /**
     * @param xmid 项目ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据项目ID删除不动产受理项目
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/xm/{xmid}")
    Integer deleteBdcSlXmByXmid(@PathVariable(value = "xmid") String xmid);

    /**
     * @param jbxxid 基本信息id
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据基本信息ID删除不动产受理项目
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/xm/list/{jbxxid}")
    Integer deleteBdcSlXmByJbxxid(@PathVariable(value = "jbxxid") String jbxxid);

    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 分页已选业务信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/yx/page")
    Page<BdcSlYwxxDTO> listBdcSlXmByPageJson(@RequestBody Pageable pageable,
                                             @RequestParam(name = "bdcSlXmQO", required = false) String bdcSlXmQO);

    /**
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 分页已选业务信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/yx/list")
    List<BdcSlYwxxDTO> listBdcSlYwxxDTO(@RequestParam(name = "bdcSlXmQO", required = false) String bdcSlXmQO);

    /**
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 分页已选业务信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/yxbdcdy/page")
    YxBdcdyDTO queryYxBdcdyDTOByPage(@RequestBody Pageable pageable,
                               @RequestParam(name = "slXmQO", required = false) String slXmQO,
                               @RequestParam(name = "gzldyid", required = false) String gzldyid,
                               @RequestParam(name = "jbxxid", required = false) String jbxxid);

    /**
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 已选业务信息(不分页)
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/yx/")
    YxBdcdyDTO queryYxBdcdyDTO(
                               @RequestParam(name = "slXmQO", required = false) String slXmQO,
                               @RequestParam(name = "gzldyid", required = false) String gzldyid,
                               @RequestParam(name = "jbxxid", required = false) String jbxxid);

    /**
     * @param jbxxid 基本信息ID
     * @return 不动产受理项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据基本信息获取不动产受理项目集合
     */
    @GetMapping("/realestate-accept/rest/v1.0/xm/yx/ywxx/list/{jbxxid}")
    List<BdcSlYwxxDTO> listBdcSlYwxxByJbxxid(@PathVariable(value = "jbxxid") String jbxxid);

    /**
     * @param bdcCshSlxmDTO 不动产初始化受理项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化受理项目信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/csh/{czrid}")
    void cshYxxm(@PathVariable(value = "czrid") String czrid, @RequestBody BdcCshSlxmDTO bdcCshSlxmDTO);

    /**
     * @param bdcCshSlxmDTO 不动产初始化受理项目
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 外联证书生成数据
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/wlzs")
    void wlZs(@RequestBody BdcCshSlxmDTO bdcCshSlxmDTO);

    /**
     * @param bdcCshSlxmDTO 不动产初始化受理项目
     * @author <a href="mailto:gailining@gtmap.cn">gaolining</a>
     * @description 外联证书生成数据,带入抵押信息生成历史关系
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/wlzs/dyaxx")
    void wlZs(@RequestBody BdcCshSlxmDTO bdcCshSlxmDTO, @RequestParam(name = "xmids", required = false) String xmids);

    /**
     * @param json 受理项目集合
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 更新受理项目
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/list/")
    Integer updateBdcSlXm(@RequestBody String json);

    /**
     * @param sczsfs 证书生成方式
     * @param jbxxid 基本信息id
     * @return 修改数量
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 更新受理项目证书序号
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/list/{sczsfs}/{jbxxid}")
    Integer updateBdcSlXmZsxh(@PathVariable(value = "sczsfs") String sczsfs, @PathVariable(value = "jbxxid") String jbxxid);

    /**
     * @param fwhsIndexs 户室主键集合，多个用英文逗号隔开
     * @param jbxxid 基本信息id
     * @return 删除数量
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据户室主键和基本信息id删除已选项目信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/list/deleteyxfwhs")
    Integer deleteYxFwhs(@RequestBody String fwhsIndexs,@RequestParam(name = "jbxxid") String jbxxid);

    /**
     * @param bdcSlXmQO 不动产受理项目查询
     * @return 受理项目集合
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据查询条件获取受理项目集合
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/list/bdcSlXm")
    List<BdcSlXmDO> listBdcSlXm(@RequestBody BdcSlXmQO bdcSlXmQO);

    /**
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据登记小类分组查询已选业务信息(不分页)
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/yx/groupbydjxl")
    List<YxBdcdyDTO> queryYxBdcdyDTOGroupByDjxl(
            @RequestParam(name = "slXmQO", required = false) String slXmQO,
            @RequestParam(name = "gzldyid", required = false) String gzldyid,
            @RequestParam(name = "jbxxid", required = false) String jbxxid);


    /**
     * @param zsxh 证书序号
     * @param jbxxid 基本信息ID
     * @return 更新数量
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 批量更新证书序号
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/list/batchUpdateZsxh")
    Integer batchUpdateBdcSlXmZsxh(@RequestParam(name = "zsxh", required = false) String zsxh, @RequestParam(value = "jbxxid") String jbxxid,@RequestParam(name = "djxl", required = false) String djxl);


    /**
     * @return 已选数据
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 查询购物车中所有的数据,需要包含原项目id
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/yx/gwc/list")
    List<BdcSlYwxxDTO> listGwcData(@RequestParam(name = "bdcSlXmQO", required = false) String bdcSlXmQO);

    /**
     * 获取不动产单元号是否重复配置
     * 选择不动产单元页面
     *
     * @param xmid xmid
     * @return 是否去除重复数据
     * @author <a href="mailto:lixin1@gtmap.cn">lixin</a>
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/bdcdyh/repeat")
    boolean bdcdyhIsRepeat(@RequestParam(name = "xmid", required = false) String xmid);

    /**
     * @param bdcSlXmQO 不动产受理项目查询
     * @return 受理项目
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 根据原xmid和jbxxid查询到购物车中的对应xmid
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/xmlsgx/bdcSlXm")
    List<BdcSlXmDO> queryBdcSlXmByLsgx(@RequestBody BdcSlXmQO bdcSlXmQO);


    /**
     *
     * @param xmid 项目id
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @return 原权利信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/qlxx/yql/{xmid}")
    BdcQl queryBdcYql(@PathVariable(name = "xmid") String xmid);


    /**
     * @param bdcXmDO 承诺期限
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 获取领证日期
     * @date : 2020/1/15 9:57
     */
    @PostMapping("/realestate-accept/rest/v1.0/xm/lzrq")
    Date getLzrq(@RequestBody BdcXmDO bdcXmDO) throws Exception;
}
