package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.accept.BdcSlSjclDO;
import cn.gtmap.realestate.common.core.dto.accept.BdcDsfSjclDTO;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/11/12
 * @description 不动产受理收件材料rest服务
 */
public interface BdcSlSjclRestService {

    /**
     * @param sjclid 收件材料ID
     * @return 不动产受理收件材料
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收件材料ID获取不动产受理收件材料
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/{sjclid}")
    BdcSlSjclDO queryBdcSlSjclBySjclid(@PathVariable(value = "sjclid") String sjclid);

    /**
     * @param xmid 项目ID
     * @return 不动产受理收件材料
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据项目ID获取不动产受理收件材料
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/list/{xmid}")
    List<BdcSlSjclDO> listBdcSlSjclByXmid(@PathVariable(value = "xmid") String xmid);

    /**
     * @param gzlslid 工作流实例ID
     * @return 不动产受理收件材料
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 工作流实例ID获取不动产受理收件材料
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/list/pl/{gzlslid}")
    List<BdcSlSjclDO> listBdcSlSjclByGzlslid(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param clmc 材料名称
     * @param gzlslid 工作流实例ID
     * @return 不动产受理收件材料
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据材料名称获取不动产受理收件材料
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/list/clmc")
    List<BdcSlSjclDO> listBdcSlSjclByClmc(@RequestParam(value = "gzlslid",required = false) String gzlslid,@RequestParam(value = "clmc") String clmc);

    /**
     * @param xmid 项目ID
     * @param gzlslid 工作流实例ID
     * @param djxl 登记小类
     * @return 不动产受理收件材料
     * @author <a href="mailto:zhangguangguang@gtmap.cn">zhangguangguang</a>
     * @description 初始化不动产受理收件材料
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/csh")
    List<BdcSlSjclDO> listCshBdcSlSjcl(@RequestParam(value = "xmid") String xmid,
                                   @RequestParam(value = "gzlslid") String gzlslid, @RequestParam(value = "djxl") String djxl);

    /**
     * @param gzlslid 工作流实例ID
     * @param xmid 项目ID
     * @author <a href="mailto:zhangguangguang@gtmap.cn">zhangguangguang</a>
     * @description 更新不动产受理收件材料页数
     */
    @PostMapping("/realestate-accept/rest/v1.0/sjcl/ys")
    Integer updateSjclYs(@RequestParam(value = "gzlslid") String gzlslid,@RequestParam(value = "xmid") String xmid);

    /**
     * @param bdcSlSjclDO 不动产受理收件材料
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 新增不动产受理收件材料
     */
    @PostMapping("/realestate-accept/rest/v1.0/sjcl/")
    BdcSlSjclDO insertBdcSlSjcl(@RequestBody BdcSlSjclDO bdcSlSjclDO);

    /**
     * @param bdcSlSjclDO 不动产受理收件材料
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 更新不动产受理收件材料
     */
    @PutMapping("/realestate-accept/rest/v1.0/sjcl/")
    Integer updateBdcSlSjcl(@RequestBody BdcSlSjclDO bdcSlSjclDO);

    /**
     * @param sjclid 收件材料ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收件材料ID删除不动产受理收件材料
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/sjcl/{sjclid}")
    void deleteBdcSlSjclBySjclid(@PathVariable(value = "sjclid") String sjclid);

    /**
     * @param gzlslid 工作流实例id
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 根据工作流实例id删除不动产受理收件材料
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/recreate/{gzlslid}")
    List<BdcSlSjclDO> reCreateSjcl(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param json
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 更新收件材料
     */
    @PostMapping("/realestate-accept/rest/v1.0/sjcl/list/")
    Integer updateBdcSlSjcl(@RequestBody String json);
    /**
     * @param sjclid，czlx
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 改变顺序号
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/sxh/{sjclid}/{czlx}")
    Integer changeSjclSxh(@PathVariable(value = "sjclid") String sjclid,@PathVariable(value = "czlx")  String czlx);

    /**
     * @param gzlslid
     * @param sjclIdsStr
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 获取收件材料名称
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/sjclmc")
    List<String> listSjclMc(@RequestParam(value = "gzlslid") String gzlslid, @RequestParam(value = "sjclIdsStr", required = false) String sjclIdsStr);

    /**
     * @param gzlslid 工作流实例ID
     * @return 是否验证通过
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 验证收件材料份数页数是否为空
     */
    @GetMapping("/realestate-accept/rest/v1.0/sjcl/gzyz/ysfs/{gzlslid}")
    Boolean checkSjclYsFs(@PathVariable(value = "gzlslid")  String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @param bdcDsfSjclDTOList 第三方收件材料
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  保存第三方收件材料
     */
    @PostMapping("/realestate-accept/rest/v1.0/sjcl/dsf/{gzlslid}")
    void saveDsfSjcl(@PathVariable(value = "gzlslid")  String gzlslid,@RequestBody List<BdcDsfSjclDTO> bdcDsfSjclDTOList) throws IOException;
}
