package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.accept.BdcSlSfxxDO;
import cn.gtmap.realestate.common.core.dto.accept.*;
import cn.gtmap.realestate.common.core.qo.accept.BdcSlSfxxQO;
import cn.gtmap.realestate.common.core.vo.accept.ui.BdcSlSfxxVO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/11/12
 * @description 不动产受理收费信息rest服务
 */
public interface BdcSlSfxxRestService {
    /**
     * @param sfxxid 收费信息ID
     * @return 不动产受理收费信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收费信息ID获取不动产受理收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/{sfxxid}")
    BdcSlSfxxDO queryBdcSlSfxxBySfxxid(@PathVariable(value = "sfxxid") String sfxxid);

    /**
     * @param jbxxid 基本信息ID
     * @return 不动产受理收费信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据基本信息ID获取不动产受理收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/list/{jbxxid}")
    List<BdcSlSfxxDO> listBdcSlSfxxByJbxxid(@PathVariable(value = "jbxxid") String jbxxid);

    /**
     * @param gzlslid 工作流实例ID
     * @return 不动产受理收费信息
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据工作流实例ID获取不动产受理收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/list/gzlslid/{gzlslid}")
    List<BdcSlSfxxDO> listBdcSlSfxxByGzlslid(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param pageable
     * @return bdcSlSfxxDOJSON
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 分页查询 收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/page")
    Page<BdcSlSfxxVO> listBdcSlSfxxByPage(Pageable pageable, @RequestParam(name = "bdcSlSfxxQOJSON", required = false) String bdcSlSfxxQOJSON);

    /**
     * @param
     * @return
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 查询 收费信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/list")
    List<BdcSlSfxxVO> listBdcSlSfxx(@RequestBody BdcSlSfxxQO bdcSlSfxxQO);
    
	/**
	 * @param
	 * @return
	 * @author <a href ="mailto:hanyi@gtmap.cn">hanyi</a>
	 * @description 查询 银行收费信息
	 */
	@PostMapping("/realestate-accept/rest/v1.0/sfxx/list/yh")
	List<BdcSlSfxxVO> listBdcSlSfxxYh(@RequestBody BdcSlSfxxQO bdcSlSfxxQO);

    /**
     * @param xmid 项目ID
     * @return 不动产受理收费信息
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据项目ID获取不动产受理收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/list/xmid/{xmid}")
    List<BdcSlSfxxDO> listBdcSlSfxxByXmid(@PathVariable(value = "xmid") String xmid);

    /**
     * @param bdcSlSfxxDO 不动产受理收费信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 新增不动产受理收费信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/")
    BdcSlSfxxDO insertBdcSlSfxx(@RequestBody BdcSlSfxxDO bdcSlSfxxDO);

    /**
     * @param bdcSlSfxxDO 不动产受理收费信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 更新不动产受理收费信息
     */
    @PutMapping("/realestate-accept/rest/v1.0/sfxx/")
    Integer updateBdcSlSfxx(@RequestBody BdcSlSfxxDO bdcSlSfxxDO);

    /**
     * @param bdcSlSfxxDO 不动产受理收费信息
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 保存或更新不动产受理收费信息
     */
    @PutMapping("/realestate-accept/rest/v1.0/sfxx/saveOrUpdate")
    Integer saveOrUpdateBdcSlSfxx(@RequestBody BdcSlSfxxDO bdcSlSfxxDO);

    /**
     * @param bdcSlSfxxDOList
     * @return Integer
     * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
     * @description 批量更新收费信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/pl/")
    Integer updateBdcSlSfxxList(@RequestBody List<BdcSlSfxxDO> bdcSlSfxxDOList);

    /**
     * @param sfxxid 收费信息ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收费信息ID删除不动产受理收费信息
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/sfxx/{sfxxid}")
    Integer deleteBdcSlSfxxBySfxxid(@PathVariable(value = "sfxxid") String sfxxid);

    /**
     * @param gzlslid 工作流实例ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收费信息ID删除不动产受理收费信息
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/sfxx/list/{gzlslid}")
    Integer deleteBdcSlSfxxByGzlslid(@PathVariable(value = "gzlslid") String gzlslid);


    /**
     * @param gzlslid 工作流实例id
     * @return 不动产受理收费信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/csh/{gzlslid}")
    BdcSlSfxxDO cshSfxx(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例id
     * @return 不动产受理收费信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 初始化非登记流程收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/yccsh/{gzlslid}")
    BdcSlSfxxDO cshFdjlcSfxx(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param xmid 项目ID
     * @param gzlslid 工作流实例id
     * @return 不动产受理收费信息
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 组织页面收费信息内容
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/generate")
    BdcSlSfxxDTO generateSfxx(@RequestParam(name = "gzlslid") String gzlslid, @RequestParam(name = "xmid") String xmid);

    /**
     * @param xmid 项目ID
     * @param gzlslid 工作流实例id
     * @return 不动产受理收费信息
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 组织页面收费信息内容(南通)
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/generate/nt")
    BdcSlSfxxDTO generateSfxxNt(@RequestParam(name = "gzlslid") String gzlslid, @RequestParam(name = "xmid") String xmid);

    /**
     * @param bdcSlSfxxDO 受理收费信息
     * @return 不动产受理收费信息
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description 更新受理收费信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/gxSfxxSfzt")
    Boolean gxSfxxSfzt(@RequestBody BdcSlSfxxDO bdcSlSfxxDO);

    /**
     * @param sfxxid 收费信息id
     * @param qlrlb 权利人类别
     * @param gzlslid 工作流实例id
     * @return 不动产受理收费信息
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description 推送收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/gxSfxxJfsbm")
    Boolean gxSfxxJfsbm(@RequestParam(name = "sfxxid") String sfxxid,@RequestParam(name = "qlrlb") String qlrlb,@RequestParam(name = "gzlslid") String gzlslid);
	
	/**
	 * @return 收费项目名称
	 * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
	 * @description 获取收费项目名称
	 */
	@GetMapping("/realestate-accept/rest/v1.0/sfxx/sfxmmc")
	Object getSfxmmc();
    
    /**
     * @param gzlslid 工作流实例ID
     * @return 不动产受理收费信息
     * @author <a href="mailto:hanyi@gtmap.cn">hanyi</a>
     * @description 根据工作流实例ID获取合计不为空的不动产受理收费信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/list/gzlslid/jefk/{gzlslid}")
    List<BdcSlSfxxDO> listBdcSlSfxxByGzlslidHjfk(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @param xmid  项目ID
     * @return 收费基本信息
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  组织一窗流程页面收费基本信息内容
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/generate/ycsl")
    BdcSlSfxxDTO generateYcslSfxx(@RequestParam(name = "gzlslid") String gzlslid, @RequestParam(name = "xmid") String xmid);

    /**
     * @param sfxxid 收费信息
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  根据收费信息ID推送待缴费信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/tsdjfxx/{sfxxid}")
    BdcTsdjfxxResponseDTO tsdjfxx(@PathVariable(value = "sfxxid") String sfxxid);

    /**
     * @param slbh 受理编号
     * @param xmid 项目ID
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  根据受理编号和项目ID推送待缴费信息外网生成支付订单
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/tsdjfxxBySlbh")
    BdcTsdjfxxResponseDTO tsdjfxxBySlbh(@RequestParam(name = "slbh") String slbh, @RequestParam(name = "xmid") String xmid);

    /**
     * @param sfxxid 收费信息
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  查询财政收费状态
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/sfzt/{sfxxid}")
    BdcQuerySfztDTO querySfzt(@PathVariable(value = "sfxxid") String sfxxid);

    /**
     * @param gzlslid 工作流实例id
     * @return
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description  根据工作流实例id查询收费页面是否点击保存按钮
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/bczt/{gzlslid}")
    Integer queryBczt(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param xmid 项目ID
     * @param sqrlb 申请人类别
     * @param cxbz 1:收费 2：收税 3:全部查询
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据xmid和申请人类别提供缴费缴税信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxx/sfssxx/{xmid}")
    BdcSfSsxxDTO queryBdcSfSsxxDTO(@PathVariable(value = "xmid")String xmid, @RequestParam(value = "sqrlb",required = false)String sqrlb,@RequestParam(value = "cxbz",required = false)String cxbz);

    /**
     * @param bdcSfSsxxDTO
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 更新收费收税状态
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/updateSfSszt")
    void updateSfSszt(@RequestBody BdcSfSsxxDTO bdcSfSsxxDTO);

    /**
     * @param gzlslid 工作流实例ID
     * @return boolean
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 回传收费收税状态（缴费状态）给大云信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/sfssxx/{gzlslid}/process")
    boolean saveSfssxxZtToProcess(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 判断当前流程是否属于线上缴费
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/isxsjf/{gzlslid}")
    boolean checkIsXsjf(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 更新收费收税银行缴库入库状态
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/updateSlSfSsxxYhJkrkzt")
    void updateSlSfSsxxYhJkrkzt(@RequestBody BdcYhjkrkztDTO bdcYhjkrkztDTO);

    /**
     *  校验缴费情况
     *  <p>通过工作流实例ID<i>gzlslid</i>,校验是否为线上缴费，是否已缴库。
     *
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param:  gzlslid  工作流实例ID
     * @return: Integer  {@code -1}为线下缴费，{@code 0}为未缴库，
     *                   {@code 1}为已缴库
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/jfqk/{gzlslid}")
    Integer checkJfqk(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @return: Integer {@code 0} 未上传凭证 {@code 1} 已上传凭证 {@code 2} 线上缴费，不做验证
     * @description 验证线下缴费是否已上传税费缴纳凭证
     */
    @GetMapping(value = "/realestate-accept/rest/v1.0/gzyz/xxJfPz/{gzlslid}")
    Integer checkXxJfPz(@PathVariable(name = "gzlslid") String gzlslid);

    /**
     * @param gzlslid 工作流实例ID
     * @retur 返回结果
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 收费信息退款申请
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/sfxxTksq")
    BdcSlSfxxDO sfxxTksq(@RequestParam(name = "gzlslid") String gzlslid);

    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 查询退款状态
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxx/querySfxxTkqk")
    BdcSlSfxxDO querySfxxTkqk(@RequestParam(name = "gzlslid") String gzlslid);

}
