package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.BdcXmDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSfxmDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSfxmPzDO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlSfxmSlDTO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlSfxmsDTO;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
 * @version 1.0, 2018/11/12
 * @description 不动产受理收费项目rest服务
 */
public interface BdcSlSfxmRestService {
    /**
     * @param sfxmid 收费项目ID
     * @return 不动产受理收费项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收费项目ID获取不动产受理收费项目
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxm/{sfxmid}")
    BdcSlSfxmDO queryBdcSlSfxmBySfxmid(@PathVariable(value = "sfxmid") String sfxmid);

    /**
     * @param sfxxid 收费信息ID
     * @return 不动产受理收费项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收费信息ID获取不动产受理收费项目
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxm/list/{sfxxid}")
    List<BdcSlSfxmDO> listBdcSlSfxmBySfxxid(@PathVariable(value = "sfxxid") String sfxxid);

    /**
     * @param bdcSlSfxmPzDOList 不动产受理收费项目配置
     * @return 不动产受理收费项目
     * @author <a href="mailto:zhangguangguang@gtmap.cn">zhangguangguang</a>
     * @description 初始化不动产受理收费项目
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxm/csh/{sfxxid}")
    List<BdcSlSfxmDO> listCshBdcSlSfxm(@RequestBody List<BdcSlSfxmPzDO> bdcSlSfxmPzDOList,@PathVariable(value = "sfxxid") String sfxxid);

    /**
     * @param bdcSlSfxmDO 不动产受理收费项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 新增不动产受理收费项目
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxm/")
    BdcSlSfxmDO insertBdcSlSfxm(@RequestBody BdcSlSfxmDO bdcSlSfxmDO);

    /**
     * @param bdcSlSfxmDO 不动产受理收费项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 更新不动产受理收费项目
     */
    @PutMapping("/realestate-accept/rest/v1.0/sfxm/")
    Integer updateBdcSlSfxm(@RequestBody BdcSlSfxmDO bdcSlSfxmDO);

    /**
     * @param sfxmid 收费项目ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收费项目ID删除不动产受理收费项目
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/sfxm/{sfxmid}")
    Integer deleteBdcSlSfxmBySfxmid(@PathVariable(value = "sfxmid") String sfxmid);

    /**
     * @param sfxxid 收费信息ID
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 根据收费信息ID删除不动产受理收费项目
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/sfxm/list/{sfxxid}")
    Integer deleteBdcSlSfxmBySfxxid(@PathVariable(value = "sfxxid") String sfxxid);

    /**
     * @param processInsId 工作流实例id
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 转发自动保存收费数据
     */
    @GetMapping("/realestate-accept/rest/v1.0/sfxm/save/zf")
    void saveSfDataForZf(@RequestParam("processInsId") String processInsId) throws Exception;

    /**
     * @param bdcSlSfxmsDTO 收费项目信息值
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 计算登记费
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxm/count/djf")
    BdcSlSfxmDO countDjf(@RequestBody BdcSlSfxmsDTO bdcSlSfxmsDTO);

    /**
     * @param bdcXmDOList 不动产项目
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 获取登记费数量（区分住宅和非住宅）
     */
    @PostMapping("/realestate-accept/rest/v1.0/sfxm/count/djf/sl")
    BdcSlSfxmSlDTO getSfxmDjfSl(@RequestBody List<BdcXmDO> bdcXmDOList);

}
