package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.dto.accept.BdcMjDTO;
import cn.gtmap.realestate.common.core.dto.accept.BdcNewPrintDTO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlDysjDTO;
import cn.gtmap.realestate.common.core.dto.accept.BdcSlPrintDTO;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
 * @version 2018/12/12,1.0
 * @description 不动产受理打印服务
 */
public interface BdcSlPrintRestService {
    /**
     * @param bdcSlPrintDTO 打印传参
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 南通版本打印获取打印地址
     */
    @PostMapping("/realestate-accept/rest/v1.0/print")
    String print(@RequestBody BdcSlPrintDTO bdcSlPrintDTO);

    /**
     * @param bdcSlPrintDTO 打印传参
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 合肥版本根据流程类型打印获取打印地址
     */
    @PostMapping("/realestate-accept/rest/v1.0/print/lclx")
    String printByLclx(@RequestBody BdcSlPrintDTO bdcSlPrintDTO);

    /**
     * @param processInsId 工作流实例id
     * @param dylx         sjd/sqs
     * @return String  获取打印xml
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 相同数据源下获取打印的xml文件
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/{processInsId}/{dylx}/{zxlc}/xml")
    String packPrintXml(@PathVariable(name = "processInsId") String processInsId, @PathVariable(name = "dylx") String dylx, @PathVariable(name = "zxlc", required = false) String zxlc, @RequestParam(name = "sjclids",required = false) String sjclids);

    /**
     * @param processInsId 工作流实例ID
     * @param dylx         sjd/sqs
     * @return String  获取打印xml
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 不同数据源下获取打印的xml文件
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/{processInsId}/{dylx}/{qlrlb}/{xmid}/xml/datas")
    String packPrintDatas(@PathVariable(name = "processInsId") String processInsId, @PathVariable(name = "dylx") String dylx, @PathVariable(name = "qlrlb") String qlrlb, @PathVariable(name = "xmid") String xmid, @RequestParam(name = "sjclids",required = false) String sjclids);

    /**
     * @param ewmnr 二维码内容
     * @param ewmurl 用于生成URL地址的二维码
     * @return String  获取打印xml
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 不同数据源下获取打印的xml文件
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/{ewmnr}/ewm")
    void packEwmPic(@PathVariable(name = "ewmnr") String ewmnr, HttpServletResponse response,@RequestParam(name = "ewmnr",required = false) String ewmurl);

    /**
     * @param gzlslid 工作流实例ID
     * @return 面积计算结果
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 面积计算
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/countmj/{gzlslid}")
    BdcMjDTO countMj(@PathVariable(value = "gzlslid") String gzlslid);

    /**
     *
     * @param processInsId 工作流实例id
     * @param dylx 打印类型
     * @param zxlc 是否注销流程
     * @description
     * @return xml
     * 相同数据源下获取打印的xml文件(从登记获取数据打印_南通)
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/{processInsId}/{dylx}/{zxlc}/xml/nt")
    String generateSlXmlToNt(@PathVariable(name = "processInsId") String processInsId, @PathVariable(name = "dylx") String dylx, @PathVariable(name = "zxlc", required = false) String zxlc);

    /**
     * @param processInsId 工作流实例ID
     * @param dylx         sjd/sqs
     * @return String  获取打印xml
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 不同数据源下获取打印的xml文件(收件单)
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/{processInsId}/{dylx}/{qlrlb}/{xmid}/xml/datas/nt")
    String packPrintDatasToNt(@PathVariable(name = "processInsId") String processInsId, @PathVariable(name = "dylx") String dylx, @PathVariable(name = "qlrlb") String qlrlb, @PathVariable(name = "xmid") String xmid);

    /**
     * @author: <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @param: [processInsId, dylx, qlrlb, xmid]
     * @return: java.lang.String
     * @description 受理数据源下获取打印的xml数据，将受理查询出来的字典项dm数据替换为字典项名称数据
     * <p>sql语句查询时，使用字符串拼接的方式将字典项字段对应的值，以（字典名称@字典dm值）fwlx@1的形式进行返回，在生成xml数据将此类型的数据进行替换为字典项的名称</p>
     * <p>例如： select id,name,value,concat('fwlx@',dzwyt) as dzwyt from a </p>
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/zd/{processInsId}/{dylx}/{qlrlb}/{xmid}/xml/datas")
    String packPrintDatasAndReplaceZd(@PathVariable(name = "processInsId") String processInsId, @PathVariable(name = "dylx") String dylx, @PathVariable(name = "qlrlb") String qlrlb, @PathVariable(name = "xmid") String xmid, @RequestParam(name = "sjclids",required = false) String sjclids);

    /**
     * @param qznr 签字内容
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 获取签名信息
     * @date : 2020/1/10 11:13
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/qmxx")
    void queryQmxxImage(HttpServletResponse response,@RequestParam(name = "bdlx", required = false) Integer bdlx,@RequestParam(name = "qzrlb", required = false) Integer qzrlb,@RequestParam(name = "xmid", required = false) String xmid);

    /**
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @param configParam 打印配置参数
     * @return List<Map> 执行结果
     * @description  执行打印配置sql信息，获取执行结果
     */
    @PostMapping("/realestate-accept/rest/v1.0/print/config/mapper")
    List<Map> executeConfigSql(@RequestBody Map configParam);

    /**
     * @param bdcSlPrintDTO
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 新模式获取打印生成xml数据源地址
     * @date : 2020/4/16 17:00
     */
    @PostMapping("/realestate-accept/rest/v1.0/print/newmode")
    BdcNewPrintDTO generatePrintDTO (@RequestBody BdcSlPrintDTO bdcSlPrintDTO);


    /**
     * @param bdcSlPrintDTO
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 获取打印特殊参数
     * @date : 2020/4/20 17:22
     */
    @PostMapping("/realestate-accept/rest/v1.0/print/tscs")
    BdcSlDysjDTO getTsDycs(@RequestBody BdcSlPrintDTO bdcSlPrintDTO);

    /**
     *  特殊业务打印需求服务（蚌埠）：获取申请人信息并调蚌埠大数据接口获取人员信息
     * @param processInsId  工作流实例ID
     * @param qlrlb         权利人类别
     * @param xmid          项目ID
     * @return Object       人员信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/bengbu/qlr/{processInsId}/{qlrlb}/{xmid}/datas")
    Object packPrintQlrDatasForBb(@PathVariable(name = "processInsId") String processInsId,
                              @PathVariable(name = "qlrlb") String qlrlb,
                              @PathVariable(name = "xmid") String xmid);

    /**
     * 获取redis中存储的base64code字符转换后的文件流图片
     * @param rediskey  权利人ID 对应存储在redis上的key
     * @author <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @description 图片文件流
     */
    @GetMapping("/realestate-accept/rest/v1.0/print/zp/{rediskey}")
    void getPrintZp(@PathVariable(name = "rediskey") String rediskey, HttpServletResponse response);
}
