package cn.gtmap.realestate.common.core.service.rest.accept;

import cn.gtmap.realestate.common.core.domain.accept.BdcSlJyxxDO;
import cn.gtmap.realestate.common.core.dto.accept.FcjyBaxxDTO;
import cn.gtmap.realestate.common.core.dto.accept.FcjyClfHtxxDTO;
import cn.gtmap.realestate.common.core.dto.accept.XgxxHttpResponseDTO;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2019/6/24
 * @description 受理交易信息rest服务
 */
public interface BdcSlJyxxRestService {

    /**
     * @param bdcSlJyxxDO 不动产受理交易信息
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 保存不动产受理交易信息
     */
    @PutMapping("/realestate-accept/rest/v1.0/jyxx/")
    BdcSlJyxxDO saveBdcSlJyxx(@RequestBody BdcSlJyxxDO bdcSlJyxxDO);

    /**
     * @param xmid 项目id
     * @return 不动产受理交易信息集合
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 根据项目id获取不动产受理交易信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/jyxx/list/{xmid}")
    List<BdcSlJyxxDO> listBdcSlJyxxByXmid(@PathVariable(value = "xmid") String xmid);

    /**
     * @param jyxxid 交易信息id
     * @return 不动产受理交易信息
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 根据交易信息id获取不动产受理交易信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/jyxx/{jyxxid}")
    BdcSlJyxxDO queryBdcSlJyxxByJyxxid(@PathVariable(value = "jyxxid") String jyxxid);

    /**
     * @param bdcSlJyxxDO 不动产交易信息Do
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 新增不动产受理交易信息
     */
    @PostMapping("/realestate-accept/rest/v1.0/jyxx/")
    BdcSlJyxxDO insertBdcSlJyxx(@RequestBody BdcSlJyxxDO bdcSlJyxxDO);

    /**
     * @param jyxxid 交易信息id
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 删除不动产受理交易信息
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/jyxx/{jyxxid}")
    Integer deleteBdcSlJyxxByJyxxid(@PathVariable(value = "jyxxid") String jyxxid);

    /**
     * @param xmid 项目id
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 删除不动产受理交易信息
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/jyxx/xm/{xmid}")
    Integer deleteBdcSlJyxxByXmid(@PathVariable(value = "xmid") String xmid);

    /**
     * @param name,cardNo 姓名，证件号码
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 房产交易限购信息接口查询
     */
    @GetMapping("/realestate-accept/rest/v1.0/jyxx/fcjyxgxx")
    XgxxHttpResponseDTO queryFcjyXgxx(@RequestParam(name = "name") String name, @RequestParam(name = "cardNo") String cardNo);

    /**
     * @param contractNo 合同号
     * @author <a href="mailto:gaolining@gtmap.cn">gaolining</a>
     * @description 房产交易存量房合同信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/jyxx/fcjyhtxx/{contractNo}/{xmid}/{fwlx}/{lclx}")
    FcjyClfHtxxDTO queryFcjyClfHtxx(@PathVariable(value = "contractNo") String contractNo, @PathVariable(value = "xmid") String xmid,
                                    @PathVariable(value = "fwlx") String fwlx, @PathVariable(value="lclx") String lclx);

    /**
     * @param gzlslid 工作流实例ID
     * @param jsonStr 更新json字符串
     * @return 受理交易信息
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 批量更新受理交易信息
     */
    @PutMapping(path = "/realestate-accept/rest/v1.0/jyxx/pl")
    int updateBatchBdcSlJyxx(@RequestParam("gzlslid")String gzlslid,@RequestParam(name = "jsonStr") String jsonStr,@RequestParam(name = "djxl", required = false) String djxl);

    /**
     * @param xmid 项目ID
     * @return 更新数据量
     * @author <a href="mailto:zhangwentao@gtmap.cn">zhangwentao</a>
     * @description 按照项目更新相关受理交易信息
     */
    @PutMapping(path = "/realestate-accept/rest/v1.0/jyxx/xm")
    int updateXmSlJyxx(@RequestParam("xmid") String xmid, @RequestParam(name = "jsonStr") String jsonStr, @RequestParam(name = "djxl", required = false) String djxl);

    /**
     * @param xmid 项目ID
     * @return 更新数据量
     * @author <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @description 按照项目更新相关受理交易信息
     */
    @PutMapping(path = "/realestate-accept/rest/v1.0/jyxx/xmid")
    int updateSlJyxxByXmid(@RequestParam("xmid") String xmid, @RequestParam(name = "jsonStr") String jsonStr, @RequestParam(name = "djxl", required = false) String djxl);

    /**
     * @param jbxxid 基本信息ID
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据基本信息ID删除不动产受理交易信息
     */
    @DeleteMapping("/realestate-accept/rest/v1.0/jyxx/list/jbxxid/{jbxxid}")
    void deleteBdcSlJyxxByJbxxid(@PathVariable(value = "jbxxid") String jbxxid);

    /**
     * @param xmid 项目ID
     * @return 缴纳状态
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 根据xmid验证合肥维修资金缴纳状态
     */
    @GetMapping("/realestate-accept/rest/v1.0/jyxx/hfwxzjyz")
    String queryHfwxzjJnzt(@RequestParam(name = "xmid") String xmid);

    /**
     * @param htbh 交易合同编号
     * @return 不动产受理交易信息
     * @author <a href="mailto:yaoyi@gtmap.cn">yaoyi</a>
     * @description 根据交易合同编号获取不动产受理交易信息
     */
    @GetMapping("/realestate-accept/rest/v1.0/jyxx/htbh")
    List<BdcSlJyxxDO> queryBdcSlJyxxByHtbh(@RequestParam(value = "htbh") String htbh);


    /**
     *
     * 处理主房关联后 再次关联附房的逻辑
     * @param fcjyBaxxDTO
     * @param xmid
     */
    @PostMapping("/realestate-accept/rest/v1.0/jyxx/dealFsssBaxx")
    void dealFsssBaxx(@RequestBody FcjyBaxxDTO fcjyBaxxDTO, @RequestParam(value = "xmid") String xmid);

}
