package cn.gtmap.realestate.common.core.qo.init;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @author <a href="mailto:lisongtao@gtmap.cn">lisongtao</a>
 * @description 不动产权利及产权证查询用QO
 */
@ApiModel(value = "BdcQlQO",description = "分页查询不动产权利页面参数封装对象")
public class BdcQlQO {
    @ApiModelProperty(value = "权利人")
    private String qlrmc;
    @ApiModelProperty(value = "权利人模糊方式 1:精确 2:左模糊 3:右模糊 4:全模糊")
    private String qlrmcmh;
    @ApiModelProperty(value = "坐落")
    private String zl;
    @ApiModelProperty(value = "坐落模糊方式 1:精确 2:左模糊 3:右模糊 4:全模糊")
    private String zlmh;
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;
    @ApiModelProperty(value = "不动产单元号模糊方式 1:精确 2:左模糊 3:右模糊 4:全模糊")
    private String bdcdyhmh;
    @ApiModelProperty(value = "证号")
    private String bdcqzh;
    @ApiModelProperty(value = "证号模糊方式 1:精确 2:左模糊 3:右模糊 4:全模糊")
    private String bdcqzhmh;
    @ApiModelProperty(value = "权属状态")
    private Integer qszt;
    @ApiModelProperty(value = "工作流实例ID")
    private String gzlslid;
    @ApiModelProperty(value = "权利类型")
    private List<String> qllx;
    @ApiModelProperty(value = "项目ID")
    private List<String> xmid;
    @ApiModelProperty(value = "定着物特征码")
    private List<String> dzwtzm;
    @ApiModelProperty(value = "宗地特征码")
    private List<String> zdtzm;
    @ApiModelProperty(value = "不动产类型")
    private List<String> bdclx;
    @ApiModelProperty(value = "项目来源")
    private List<Integer> xmly;
    @ApiModelProperty(value = "受理编号")
    private String slbh;
    @ApiModelProperty(value = "证号流水号")
    private String zhlsh;
    @ApiModelProperty(value = "年份")
    private String nf;
    @ApiModelProperty(value = "幢号")
    private String zh;
    @ApiModelProperty(value = "幢号模糊方式 1:精确 2:左模糊 3:右模糊 4:全模糊")
    private String zhmh;
    @ApiModelProperty(value = "房间号")
    private String fjh;
    @ApiModelProperty(value = "房间号模糊方式 1:精确 2:左模糊 3:右模糊 4:全模糊")
    private String fjhmh;

    @ApiModelProperty(value = "权利人证件号")
    private String qlrzjh;
    @ApiModelProperty(value = "模糊搜索BDCDY")
    private String bdcdyhlike;
    @ApiModelProperty(value = "原产权证号")
    private String ycqzh;
    @ApiModelProperty(value = "TT系统证号")
    private String yxtcqzh;
    @ApiModelProperty(value = "TT系统证号模糊方式 1:精确 2:左模糊 3:右模糊 4:全模糊")
    private String yxtcqzhmh;
    @ApiModelProperty(value = "多个不动产单元号集合")
    private List<String> bdcdyhList;
    @ApiModelProperty(value = "是否只显示虚拟单元号")
    private boolean xndyh;
    @ApiModelProperty(value = "多个权利人证件号集合")
    private List<String> qlrzjhList;
    @ApiModelProperty(value = "是否只显示存量过渡数据")
    private boolean clgdsj;
    @ApiModelProperty(value = "分别持证是否显示多条数据")
    private boolean fbczdt;
    @ApiModelProperty(value = "工作流定义id")
    private String gzldyid;

    @ApiModelProperty(value = "证书类型")
    private Integer zslx;

    public boolean isXndyh() {
        return xndyh;
    }

    public void setXndyh(boolean xndyh) {
        this.xndyh = xndyh;
    }

    public String getZh() {
        return zh;
    }

    public void setZh(String zh) {
        this.zh = zh;
    }

    public String getFjh() {
        return fjh;
    }

    public void setFjh(String fjh) {
        this.fjh = fjh;
    }

    public String getNf() {
        return nf;
    }

    public void setNf(String nf) {
        this.nf = nf;
    }

    public List<Integer> getXmly() {
        return xmly;
    }

    public void setXmly(List<Integer> xmly) {
        this.xmly = xmly;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getQlrmcmh() {
        if (StringUtils.isBlank(qlrmcmh)){
            return "3";
        }else {
            return qlrmcmh;
        }
    }

    public String getZhmh() {
        if (StringUtils.isBlank(zhmh)){
            return "1";
        }else {
            return zhmh;
        }
    }

    public void setZhmh(String zhmh) {
        this.zhmh = zhmh;
    }

    public String getFjhmh() {
        if (StringUtils.isBlank(fjhmh)){
            return "1";
        }else {
            return fjhmh;
        }
    }

    public void setFjhmh(String fjhmh) {
        this.fjhmh = fjhmh;
    }

    public void setQlrmcmh(String qlrmcmh) {
        this.qlrmcmh = qlrmcmh;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getZlmh() {
        if (StringUtils.isBlank(zlmh)){
            return "4";
        }else {
            return zlmh;
        }
    }

    public void setZlmh(String zlmh) {
        this.zlmh = zlmh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getBdcdyhmh() {
        if (StringUtils.isBlank(bdcdyhmh)){
            return "1";
        }else {
            return bdcdyhmh;
        }
    }

    public void setBdcdyhmh(String bdcdyhmh) {
        this.bdcdyhmh = bdcdyhmh;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getBdcqzhmh() {
        if (StringUtils.isBlank(bdcqzhmh)){
            return "4";
        }else {
            return bdcqzhmh;
        }
    }

    public void setBdcqzhmh(String bdcqzhmh) {
        this.bdcqzhmh = bdcqzhmh;
    }

    public String getZhlsh() {
        return zhlsh;
    }

    public void setZhlsh(String zhlsh) {
        this.zhlsh = zhlsh;
    }

    public Integer getQszt() {
        return qszt;
    }

    public void setQszt(Integer qszt) {
        this.qszt = qszt;
    }

    public String getGzlslid() {
        return gzlslid;
    }

    public void setGzlslid(String gzlslid) {
        this.gzlslid = gzlslid;
    }

    public List<String> getQllx() {
        return qllx;
    }

    public void setQllx(List<String> qllx) {
        this.qllx = qllx;
    }

    public List<String> getXmid() {
        return xmid;
    }

    public void setXmid(List<String> xmid) {
        this.xmid = xmid;
    }

    public List<String> getDzwtzm() {
        return dzwtzm;
    }

    public void setDzwtzm(List<String> dzwtzm) {
        this.dzwtzm = dzwtzm;
    }

    public List<String> getZdtzm() {
        return zdtzm;
    }

    public void setZdtzm(List<String> zdtzm) {
        this.zdtzm = zdtzm;
    }

    public List<String> getBdclx() {
        return bdclx;
    }

    public void setBdclx(List<String> bdclx) {
        this.bdclx = bdclx;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getBdcdyhlike() {
        return bdcdyhlike;
    }

    public void setBdcdyhlike(String bdcdyhlike) {
        this.bdcdyhlike = bdcdyhlike;
    }

    public String getYcqzh() {
        return ycqzh;
    }

    public void setYcqzh(String ycqzh) {
        this.ycqzh = ycqzh;
    }

    public String getYxtcqzh() {
        return yxtcqzh;
    }

    public void setYxtcqzh(String yxtcqzh) {
        this.yxtcqzh = yxtcqzh;
    }

    public String getYxtcqzhmh() {
        if (StringUtils.isBlank(yxtcqzhmh)){
            return "3";
        }else {
            return yxtcqzhmh;
        }
    }

    public void setYxtcqzhmh(String yxtcqzhmh) {
        this.yxtcqzhmh = yxtcqzhmh;
    }

    public List<String> getBdcdyhList() {
        return bdcdyhList;
    }

    public void setBdcdyhList(List<String> bdcdyhList) {
        this.bdcdyhList = bdcdyhList;
    }

    public boolean isClgdsj() {
        return clgdsj;
    }

    public void setClgdsj(boolean clgdsj) {
        this.clgdsj = clgdsj;
    }

    public boolean isFbczdt() {
        return fbczdt;
    }

    public void setFbczdt(boolean fbczdt) {
        this.fbczdt = fbczdt;
    }

    public String getGzldyid() {
        return gzldyid;
    }

    public void setGzldyid(String gzldyid) {
        this.gzldyid = gzldyid;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BdcQlQO{");
        sb.append("qlrmc='").append(qlrmc).append('\'');
        sb.append(", qlrmcmh='").append(qlrmcmh).append('\'');
        sb.append(", zl='").append(zl).append('\'');
        sb.append(", bdcdyh='").append(bdcdyh).append('\'');
        sb.append(", bdcqzh='").append(bdcqzh).append('\'');
        sb.append(", qszt=").append(qszt);
        sb.append(", gzlslid='").append(gzlslid).append('\'');
        sb.append(", qllx=").append(qllx);
        sb.append(", xmid=").append(xmid);
        sb.append(", dzwtzm=").append(dzwtzm);
        sb.append(", zdtzm=").append(zdtzm);
        sb.append(", bdclx=").append(bdclx);
        sb.append(", xmly=").append(xmly);
        sb.append(", slbh='").append(slbh).append('\'');
        sb.append(", zhlsh='").append(zhlsh).append('\'');
        sb.append(", nf='").append(nf).append('\'');
        sb.append(", zh='").append(zh).append('\'');
        sb.append(", fjh='").append(fjh).append('\'');
        sb.append(", qlrzjh='").append(qlrzjh).append('\'');
        sb.append(", bdcdyhlike='").append(bdcdyhlike).append('\'');
        sb.append(", ycqzh='").append(ycqzh).append('\'');
        sb.append(", yxtcqzh='").append(yxtcqzh).append('\'');
        sb.append(", bdcdyhList=").append(bdcdyhList);

        sb.append('}');
        return sb.toString();
    }

    public List<String> getQlrzjhList() {
        return qlrzjhList;
    }

    public void setQlrzjhList(List<String> qlrzjhList) {
        this.qlrzjhList = qlrzjhList;
    }

    public Integer getZslx() {
        return zslx;
    }

    public void setZslx(Integer zslx) {
        this.zslx = zslx;
    }
}
