package cn.gtmap.realestate.common.core.qo.certificate;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:bianwen@gtmap.cn">bianwen</a>"
 * @version 1.0, 2018/11/11
 * @description 不动产证书查询QO
 */
@ApiModel(value = "BdcZsQO", description = "不动产证书查询对象")
public class BdcZsQO implements Serializable {

    private static final long serialVersionUID = -7450441730450562901L;
    @ApiModelProperty(value = "记录当前是哪个页面请求的")
    private String resourceName;

    @ApiModelProperty(value = "证书类型")
    private Integer zslx;

    @ApiModelProperty(value = "不动产权证号")
    private String bdcqzh;

    @ApiModelProperty(value = "注销原权利")
    private Integer zxyql;

    @ApiModelProperty(value = "坐落")
    private String zl;

    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;

    @ApiModelProperty(value = "项目id")
    private String xmid;

    @ApiModelProperty(value = "工作流实例id")
    private String gzlslid;

    @ApiModelProperty(value = "证书ID", hidden = true)
    private String zsid;

    @ApiModelProperty(value = "权利人")
    private String qlr;

    @ApiModelProperty(value = "时间")
    private Date date;

    @ApiModelProperty(value = "日期格式模式")
    private String datePattern;


    @ApiModelProperty(value = "项目权属状态List")
    private List<Integer> qsztList;

    @ApiModelProperty(value = "证书IDList")
    private List<String> zsidList;

    @ApiModelProperty(value = "用户信息")
    private UserDto userDto;

    @ApiModelProperty(value = "其他查询sql字符串，用于补充查询语句")
    private String sqlStr;

    public Integer getZxyql() {
        return zxyql;
    }

    public void setZxyql(Integer zxyql) {
        this.zxyql = zxyql;
    }
    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
    public String getSqlStr() {
        return sqlStr;
    }

    public void setSqlStr(String sqlStr) {
        this.sqlStr = sqlStr;
    }

    public Integer getZslx() {
        return zslx;
    }

    public void setZslx(Integer zslx) {
        this.zslx = zslx;
    }

    public List<String> getZsidList() {
        return zsidList;
    }

    public void setZsidList(List<String> zsidList) {
        this.zsidList = zsidList;
    }

    public UserDto getUserDto() {
        return userDto;
    }

    public void setUserDto(UserDto userDto) {
        this.userDto = userDto;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getGzlslid() {
        return gzlslid;
    }

    public void setGzlslid(String gzlslid) {
        this.gzlslid = gzlslid;
    }

    public String getZsid() {
        return zsid;
    }

    public void setZsid(String zsid) {
        this.zsid = zsid;
    }

    public String getQlr() {
        return qlr;
    }

    public void setQlr(String qlr) {
        this.qlr = qlr;
    }

    public List<Integer> getQsztList() {
        return qsztList;
    }

    public void setQsztList(List<Integer> qsztList) {
        this.qsztList = qsztList;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getDatePattern() {
        return datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    @Override
    public String toString() {
        return "BdcZsQO{" +
                "resourceName='" + resourceName + '\'' +
                ", zslx=" + zslx +
                ", bdcqzh='" + bdcqzh + '\'' +
                ", zxyql=" + zxyql +
                ", zl='" + zl + '\'' +
                ", bdcdyh='" + bdcdyh + '\'' +
                ", xmid='" + xmid + '\'' +
                ", gzlslid='" + gzlslid + '\'' +
                ", zsid='" + zsid + '\'' +
                ", qlr='" + qlr + '\'' +
                ", date=" + date +
                ", datePattern='" + datePattern + '\'' +
                ", qsztList=" + qsztList +
                ", zsidList=" + zsidList +
                ", userDto=" + userDto +
                ", sqlStr='" + sqlStr + '\'' +
                '}';
    }
}
