package cn.gtmap.realestate.common.core.dto.inquiry;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/7/8
 * @description  不动产住房信息查询结果DTO定义
 */
public class BdcZfxxDTO {
    @ApiModelProperty(value = "不动产权证号（房产证号）")
    private String bdcqzh;

    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;

    @ApiModelProperty(value = "权利人名称")
    private String qlrmc;

    @ApiModelProperty(value = "权利人证件号")
    private String qlrzjh;

    @ApiModelProperty(value = "坐落")
    private String zl;

    @ApiModelProperty(value = "建筑面积")
    private Double jzmj;

    @ApiModelProperty(value = "规划用途")
    private String ghyt;

    @ApiModelProperty(value = "规划用途代码")
    private String ghytdm;

    @ApiModelProperty(value = "共有情况")
    private String gyqk;

    @ApiModelProperty(value = "受理人")
    private String slr;

    @ApiModelProperty(value = "受理编号")
    private String slbh;

    @ApiModelProperty(value = "登记类型")
    private String djlx;

    @ApiModelProperty(value = "登记原因")
    private String djyy;

    @ApiModelProperty(value = "登记时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date djsj;

    @ApiModelProperty(value = "项目ID")
    private String xmid;

    @ApiModelProperty(value = "项目来源")
    private Integer xmly;

    @ApiModelProperty(value = "不动产单元唯一编号")
    private String bdcdywybh;

    @ApiModelProperty(value = "原系统产权证号")
    private String yxtcqzh;

    @ApiModelProperty(value = "附记")
    private String fj;

    @ApiModelProperty(value = "权利主键")
    private String qlid;

    @ApiModelProperty(value = "权利类型")
    private String qllx;

    @ApiModelProperty(value = "权利性质")
    private String qlxz;

    @ApiModelProperty(value = "权属状态")
    private String qszt;

    @ApiModelProperty(value = "交易合同号")
    private String jyhth;

    @ApiModelProperty(value = "宗地面积")
    private String zdmj;

    @ApiModelProperty(value = "土地使用起始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date tdsyqssj;

    @ApiModelProperty(value = "土地使用结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date tdsyjssj;

    @ApiModelProperty(value = "不动产类型")
    private String bdclx;

    @ApiModelProperty(value = "所在层")
    private String szc;

    @ApiModelProperty(value = "总层数")
    private String zcs;

    @ApiModelProperty(value = "所在名义层")
    private String szmyc;

    @ApiModelProperty(value = "房屋性质")
    private String fwxz;


    public String getGhytdm() {
        return ghytdm;
    }

    public void setGhytdm(String ghytdm) {
        this.ghytdm = ghytdm;
    }

    public String getQlid() {
        return qlid;
    }

    public void setQlid(String qlid) {
        this.qlid = qlid;
    }

    public String getQllx() {
        return qllx;
    }

    public void setQllx(String qllx) {
        this.qllx = qllx;
    }

    public String getQlxz() {
        return qlxz;
    }

    public void setQlxz(String qlxz) {
        this.qlxz = qlxz;
    }

    public String getQszt() {
        return qszt;
    }

    public void setQszt(String qszt) {
        this.qszt = qszt;
    }

    public String getJyhth() {
        return jyhth;
    }

    public void setJyhth(String jyhth) {
        this.jyhth = jyhth;
    }

    public String getZdmj() {
        return zdmj;
    }

    public void setZdmj(String zdmj) {
        this.zdmj = zdmj;
    }

    public Date getTdsyqssj() {
        return tdsyqssj;
    }

    public void setTdsyqssj(Date tdsyqssj) {
        this.tdsyqssj = tdsyqssj;
    }

    public Date getTdsyjssj() {
        return tdsyjssj;
    }

    public void setTdsyjssj(Date tdsyjssj) {
        this.tdsyjssj = tdsyjssj;
    }

    public String getBdclx() {
        return bdclx;
    }

    public void setBdclx(String bdclx) {
        this.bdclx = bdclx;
    }

    public String getSzc() {
        return szc;
    }

    public void setSzc(String szc) {
        this.szc = szc;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public String getBdcqzh() {
        return bdcqzh;
    }

    public void setBdcqzh(String bdcqzh) {
        this.bdcqzh = bdcqzh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getQlrzjh() {
        return qlrzjh;
    }

    public void setQlrzjh(String qlrzjh) {
        this.qlrzjh = qlrzjh;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public Double getJzmj() {
        return jzmj;
    }

    public void setJzmj(Double jzmj) {
        this.jzmj = jzmj;
    }

    public String getGhyt() {
        return ghyt;
    }

    public void setGhyt(String ghyt) {
        this.ghyt = ghyt;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public String getSlr() {
        return slr;
    }

    public void setSlr(String slr) {
        this.slr = slr;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getDjlx() {
        return djlx;
    }

    public void setDjlx(String djlx) {
        this.djlx = djlx;
    }

    public String getDjyy() {
        return djyy;
    }

    public void setDjyy(String djyy) {
        this.djyy = djyy;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public Integer getXmly() {
        return xmly;
    }

    public void setXmly(Integer xmly) {
        this.xmly = xmly;
    }

    public String getBdcdywybh() {
        return bdcdywybh;
    }

    public void setBdcdywybh(String bdcdywybh) {
        this.bdcdywybh = bdcdywybh;
    }

    public String getYxtcqzh() {
        return yxtcqzh;
    }

    public void setYxtcqzh(String yxtcqzh) {
        this.yxtcqzh = yxtcqzh;
    }


    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BdcZfxxDTO{");
        sb.append("bdcqzh='").append(bdcqzh).append('\'');
        sb.append(", bdcdyh='").append(bdcdyh).append('\'');
        sb.append(", qlrmc='").append(qlrmc).append('\'');
        sb.append(", qlrzjh='").append(qlrzjh).append('\'');
        sb.append(", zl='").append(zl).append('\'');
        sb.append(", jzmj=").append(jzmj);
        sb.append(", ghyt='").append(ghyt).append('\'');
        sb.append(", gyqk='").append(gyqk).append('\'');
        sb.append(", slr='").append(slr).append('\'');
        sb.append(", slbh='").append(slbh).append('\'');
        sb.append(", djlx='").append(djlx).append('\'');
        sb.append(", djyy='").append(djyy).append('\'');
        sb.append(", djsj=").append(djsj);
        sb.append(", xmid='").append(xmid).append('\'');
        sb.append(", xmly=").append(xmly);
        sb.append(", bdcdywybh='").append(bdcdywybh).append('\'');
        sb.append(", yxtcqzh='").append(yxtcqzh).append('\'');
        sb.append(", fj='").append(fj).append('\'');
        sb.append(", qlid='").append(qlid).append('\'');
        sb.append(", qllx='").append(qllx).append('\'');
        sb.append(", qlxz='").append(qlxz).append('\'');
        sb.append(", qszt='").append(qszt).append('\'');
        sb.append(", jyhth='").append(jyhth).append('\'');
        sb.append(", zdmj='").append(zdmj).append('\'');
        sb.append(", tdsyqssj=").append(tdsyqssj);
        sb.append(", tdsyjssj=").append(tdsyjssj);
        sb.append(", bdclx='").append(bdclx).append('\'');
        sb.append(", szc='").append(szc).append('\'');
        sb.append(", zcs='").append(zcs).append('\'');
        sb.append(", szmyc='").append(szmyc).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getZcs() {
        return zcs;
    }

    public void setZcs(String zcs) {
        this.zcs = zcs;
    }

    public String getSzmyc() {
        return szmyc;
    }

    public void setSzmyc(String szmyc) {
        this.szmyc = szmyc;
    }

    public String getFwxz() {
        return fwxz;
    }

    public void setFwxz(String fwxz) {
        this.fwxz = fwxz;
    }
}
