package cn.gtmap.realestate.common.core.dto.inquiry;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * @author <a href="mailto:zhuyong@gtmap.cn">zhuyong</a>
 * @version 1.0, 2019/7/16
 * @description  查询子系统：房地产权信息DTO
 */
public class BdcFdcqDTO {
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;

    @ApiModelProperty(value = "坐落")
    private String zl;

    @ApiModelProperty(value = "总层数")
    private Integer zcs;

    @ApiModelProperty(value = "所在层")
    private Integer szc;

    @ApiModelProperty(value = "所在名义层")
    private String szmyc;

    @ApiModelProperty(value = "规划用途")
    private Integer ghyt;

    @ApiModelProperty(value = "房屋性质")
    private Integer fwxz;

    @ApiModelProperty(value = "建筑面积")
    private Double jzmj;

    @ApiModelProperty(value = "专有（套内）建筑面积")
    private Double zyjzmj;

    @ApiModelProperty(value = "分摊建筑面积")
    private Double ftjzmj;

    @ApiModelProperty(value = "竣工时间", example = "2018-10-01")
    private String jgsj;

    @ApiModelProperty(value = "独用土地面积")
    private Double dytdmj;

    @ApiModelProperty(value = "分摊土地面积")
    private Double fttdmj;

    @ApiModelProperty(value = "共有情况")
    private String gyqk;

    @ApiModelProperty(value = "附记")
    private String fj;

    @ApiModelProperty(value = "土地使用权面积")
    private Double tdsyqmj;

    @ApiModelProperty(value = "土地使用起始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date tdsyqssj;

    @ApiModelProperty(value = "土地使用结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date tdsyjssj;

    @ApiModelProperty(value = "宗地宗海面积")
    private Double zdzhmj;

    @ApiModelProperty(value = "宗地宗海用途")
    private String zdzhyt;

    @ApiModelProperty(value = "权利类型")
    private Integer qllx;

    @ApiModelProperty(value = "权利性质")
    private Integer qlxz;

    @ApiModelProperty(value = "幢号")
    private String zh;

    @ApiModelProperty(value = "房间号")
    private String fjh;


    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public Integer getZcs() {
        return zcs;
    }

    public void setZcs(Integer zcs) {
        this.zcs = zcs;
    }

    public Integer getSzc() {
        return szc;
    }

    public void setSzc(Integer szc) {
        this.szc = szc;
    }

    public Integer getGhyt() {
        return ghyt;
    }

    public void setGhyt(Integer ghyt) {
        this.ghyt = ghyt;
    }

    public Integer getFwxz() {
        return fwxz;
    }

    public void setFwxz(Integer fwxz) {
        this.fwxz = fwxz;
    }

    public Double getJzmj() {
        return jzmj;
    }

    public void setJzmj(Double jzmj) {
        this.jzmj = jzmj;
    }

    public Double getZyjzmj() {
        return zyjzmj;
    }

    public void setZyjzmj(Double zyjzmj) {
        this.zyjzmj = zyjzmj;
    }

    public Double getFtjzmj() {
        return ftjzmj;
    }

    public void setFtjzmj(Double ftjzmj) {
        this.ftjzmj = ftjzmj;
    }

    public String getJgsj() {
        return jgsj;
    }

    public void setJgsj(String jgsj) {
        this.jgsj = jgsj;
    }

    public Double getDytdmj() {
        return dytdmj;
    }

    public void setDytdmj(Double dytdmj) {
        this.dytdmj = dytdmj;
    }

    public Double getFttdmj() {
        return fttdmj;
    }

    public void setFttdmj(Double fttdmj) {
        this.fttdmj = fttdmj;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public Double getTdsyqmj() {
        return tdsyqmj;
    }

    public void setTdsyqmj(Double tdsyqmj) {
        this.tdsyqmj = tdsyqmj;
    }

    public Date getTdsyqssj() {
        return tdsyqssj;
    }

    public void setTdsyqssj(Date tdsyqssj) {
        this.tdsyqssj = tdsyqssj;
    }

    public Date getTdsyjssj() {
        return tdsyjssj;
    }

    public void setTdsyjssj(Date tdsyjssj) {
        this.tdsyjssj = tdsyjssj;
    }

    public Double getZdzhmj() {
        return zdzhmj;
    }

    public void setZdzhmj(Double zdzhmj) {
        this.zdzhmj = zdzhmj;
    }

    public String getZdzhyt() {
        return zdzhyt;
    }

    public void setZdzhyt(String zdzhyt) {
        this.zdzhyt = zdzhyt;
    }

    public Integer getQllx() {
        return qllx;
    }

    public void setQllx(Integer qllx) {
        this.qllx = qllx;
    }

    public Integer getQlxz() {
        return qlxz;
    }

    public void setQlxz(Integer qlxz) {
        this.qlxz = qlxz;
    }

    public String getZh() {
        return zh;
    }

    public void setZh(String zh) {
        this.zh = zh;
    }

    public String getFjh() {
        return fjh;
    }

    public void setFjh(String fjh) {
        this.fjh = fjh;
    }

    public String getSzmyc() {
        return szmyc;
    }

    public void setSzmyc(String szmyc) {
        this.szmyc = szmyc;
    }

    @Override
    public String toString() {
        return "BdcFdcqDTO{" +
                "bdcdyh='" + bdcdyh + '\'' +
                ", zl='" + zl + '\'' +
                ", zcs=" + zcs +
                ", szc=" + szc +
                ", szmyc='" + szmyc + '\'' +
                ", ghyt=" + ghyt +
                ", fwxz=" + fwxz +
                ", jzmj=" + jzmj +
                ", zyjzmj=" + zyjzmj +
                ", ftjzmj=" + ftjzmj +
                ", jgsj='" + jgsj + '\'' +
                ", dytdmj=" + dytdmj +
                ", fttdmj=" + fttdmj +
                ", gyqk='" + gyqk + '\'' +
                ", fj='" + fj + '\'' +
                ", tdsyqmj=" + tdsyqmj +
                ", tdsyqssj=" + tdsyqssj +
                ", tdsyjssj=" + tdsyjssj +
                ", zdzhmj=" + zdzhmj +
                ", zdzhyt='" + zdzhyt + '\'' +
                ", qllx=" + qllx +
                ", qlxz=" + qlxz +
                ", zh='" + zh + '\'' +
                ", fjh='" + fjh + '\'' +
                '}';
    }
}
