package cn.gtmap.realestate.common.core.dto.building;

import cn.gtmap.realestate.common.core.domain.building.FwFcqlrDO;
import cn.gtmap.realestate.common.core.domain.building.FwLjzDO;
import cn.gtmap.realestate.common.core.domain.building.FwZhsDO;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:liyinqiao@gtmap.cn">liyinqiao</a>
 * @version 1.0  2018-11-07
 * @description 不动产单元详细信息DTO
 */
@ApiModel(value = "BdcdyResponseDTO", description = "不动产单元详细信息DTO")
public class BdcdyResponseDTO {

    /**
     * 区分户室类型为户室 还是预测户室
     */
    @ApiModelProperty(value = "户室类型（sc/yc）")
    private String hslx;

    /**
     * 地籍ID
     */
    @ApiModelProperty(value = "地籍ID")
    private String djid;

    /**
     * 逻辑幢主键
     */
    @ApiModelProperty(value = "逻辑幢主键")
    private String fwDcbIndex;

    /**
     * 不动产单元房屋类型
     */
    @ApiModelProperty(value = "不动产单元房屋类型")
    private String bdcdyfwlx;

    /**
     * 隶属宗地
     */
    @ApiModelProperty(value = "隶属宗地")
    private String lszd;

    /**
     * 自然幢号
     */
    @ApiModelProperty(value = "自然幢号")
    private String zrzh;

    /**
     * 自然幢号
     */
    @ApiModelProperty(value = "栋号")
    private String dh;

    /**
     * 不动产单元编号
     */
    @ApiModelProperty(value = "不动产单元编号")
    private String bdcdyh;

    /**
     * 项目名称
     */
    @ApiModelProperty(value = "项目名称")
    private String xmmc;
    /**
     * 物理层数
     */
    @ApiModelProperty(value = "物理层数")
    private Integer wlcs;
    /**
     * 房间号
     */
    @ApiModelProperty(value = "房间号")
    private String fjh;
    /**
     * 定义层数
     */
    @ApiModelProperty(value = "定义层数")
    private String dycs;
    /**
     * 单元号
     */
    @ApiModelProperty(value = "单元号")
    private String dyh;
    /**
     * 室序号
     */
    @ApiModelProperty(value = "室序号")
    private Integer sxh;
    /**
     * 层号
     */
    @ApiModelProperty(value = "层号")
    private Integer ch;
    /**
     * 层高
     */
    @ApiModelProperty(value = "层高")
    private Double cg;
    /**
     * 共有土地面积
     */
    @ApiModelProperty(value = "共有土地面积")
    private Double gytdmj;
    /**
     * 分摊土地面积
     */
    @ApiModelProperty(value = "分摊土地面积")
    private Double fttdmj;
    /**
     * 独用土地面积
     */
    @ApiModelProperty(value = "独用土地面积")
    private Double dytdmj;
    /**
     * 预测建筑面积
     */
    @ApiModelProperty(value = "预测建筑面积")
    private Double ycjzmj;
    /**
     * 预测套内建筑面积
     */
    @ApiModelProperty(value = "预测套内建筑面积")
    private Double yctnjzmj;
    /**
     * 预测分摊建筑面积
     */
    @ApiModelProperty(value = "预测分摊建筑面积")
    private Double ycftjzmj;
    /**
     * 预测地下部分建筑面积
     */
    @ApiModelProperty(value = "预测地下部分建筑面积")
    private Double ycdxbfjzmj;
    /**
     * 预测其它建筑面积
     */
    @ApiModelProperty(value = "预测其它建筑面积")
    private Double ycqtjzmj;
    /**
     * 预测分摊系数
     */
    @ApiModelProperty(value = "预测分摊系数")
    private Double ycftxs;
    /**
     * 实测建筑面积
     */
    @ApiModelProperty(value = "实测建筑面积")
    private Double scjzmj;
    /**
     * 实测套内建筑面积
     */
    @ApiModelProperty(value = "实测套内建筑面积")
    private Double sctnjzmj;
    /**
     * 实测分摊建筑面积
     */
    @ApiModelProperty(value = "实测分摊建筑面积")
    private Double scftjzmj;
    /**
     * 实测地下部分建筑面积
     */
    @ApiModelProperty(value = "实测地下部分建筑面积")
    private Double scdxbfjzmj;
    /**
     * 实测其它建筑面积
     */
    @ApiModelProperty(value = "实测其它建筑面积")
    private Double scqtjzmj;
    /**
     * 实测分摊系数
     */
    @ApiModelProperty(value = "实测分摊系数")
    private Double scftxs;
    /**
     * 交易价格
     */
    @ApiModelProperty(value = "交易价格")
    private Double jyjg;
    /**
     * 坐落
     */
    @ApiModelProperty(value = "坐落")
    private String zl;
    /**
     * 规划用途
     */
    @ApiModelProperty(value = "规划用途")
    private String ghyt;
    /**
     * 规划用途2
     */
    @ApiModelProperty(value = "规划用途2")
    private String ghyt2;
    /**
     * 规划用途3
     */
    @ApiModelProperty(value = "规划用途3")
    private String ghyt3;
    /**
     * 房屋类型
     */
    @ApiModelProperty(value = "房屋类型")
    private String fwlx;
    /**
     * 房屋性质
     */
    @ApiModelProperty(value = "房屋性质")
    private String fwxz;

    /**
     * 产权来源
     */
    @ApiModelProperty(value = "产权来源")
    private String cqly;

    /**
     * 户型结构
     */
    @ApiModelProperty(value = "户型结构")
    private String hxjg;
    /**
     * 房产档案号
     */
    @ApiModelProperty(value = "房产档案号")
    private String fcdah;

    /**
     * 共有情况
     */
    @ApiModelProperty(value = "共有情况")
    private String gyqk;

    /**
     * 权利状态
     */
    @ApiModelProperty(value = "权利状态")
    private String qlzt;

    /**
     * 不动产状态
     */
    @ApiModelProperty(value = "不动产状态")
    private String bdczt;

    /**
     * 幢List  项目内多幢时有值
     */
    @ApiModelProperty(value = "幢List")
    private List<FwLjzDO> ljzList;

    /**
     * 权利人LIST
     */
    @ApiModelProperty(value = "权利人LIST")
    private List<FwFcqlrDO> qlrList;
    /**
     * 子户室LIST
     */
    @ApiModelProperty(value = "子户室LIST")
    private List<FwZhsDO> fwZhsList;

    /**
     * 房屋编码
     */
    @ApiModelProperty(value = "房屋编码")
    private String fwbm;

    /**
     * 房屋层数
     */
    @ApiModelProperty(value = "房屋层数")
    private Integer fwcs;

    /**
     * 竣工日期
     */
    @ApiModelProperty(value = "竣工日期",example = "2018-10-01 12:18:48")
    private Date jgrq;

    /**
     * 幢占地面积
     */
    @ApiModelProperty(value = "幢占地面积")
    private String zzdmj;

    /**
     * 总套数
     */
    @ApiModelProperty(value = "总套数")
    private Integer zts;

    /**
     * 起始日期
     */
    @ApiModelProperty(value = "起始日期",example = "2018-10-01 12:18:48")
    private Date qsrq;

    /**
     * 终止日期
     */
    @ApiModelProperty(value = "终止日期",example = "2018-10-01 12:18:48")
    private Date zzrq;
    /**
     * 附加说明
     */
    @ApiModelProperty(value = "附加说明")
    private String fjsm;
    /**
     * 调查意见
     */
    @ApiModelProperty(value = "调查意见")
    private String dcyj;
    /**
     * 调查者
     */
    @ApiModelProperty(value = "调查者")
    private String dcz;
    /**
     * 调查时间
     */
    @ApiModelProperty(value = "调查时间",example = "2018-10-01 12:18:21")
    private Date dcsj;

    /**
     * 土地用途
     */
    @ApiModelProperty(value = "土地用途")
    private String tdyt;

    /**
     * 房屋结构  户室类型取幢信息中的FWJG
     */
    @ApiModelProperty(value = "房屋结构")
    private String fwjg;

    /**
     * 预售房屋编码（房产系统的）
     */
    @ApiModelProperty(value = "房产预售房屋编码")
    private String ysfwbm;


    @ApiModelProperty(value = "地上层数")
    private Integer dscs;

    @ApiModelProperty(value = "土地使用权类型")
    private String tdsyqlx;

    @ApiModelProperty(value = "预售许可证号")
    private String ysxkzh;

    @ApiModelProperty(value = "规划许可证号")
    private String ghxkzh;

    public String getYsfwbm() {
        return ysfwbm;
    }

    public void setYsfwbm(String ysfwbm) {
        this.ysfwbm = ysfwbm;
    }

    public String getFjsm() {
        return fjsm;
    }

    public void setFjsm(String fjsm) {
        this.fjsm = fjsm;
    }

    public String getDcyj() {
        return dcyj;
    }

    public void setDcyj(String dcyj) {
        this.dcyj = dcyj;
    }

    public String getDcz() {
        return dcz;
    }

    public void setDcz(String dcz) {
        this.dcz = dcz;
    }

    public Date getDcsj() {
        return dcsj;
    }

    public void setDcsj(Date dcsj) {
        this.dcsj = dcsj;
    }

    public Date getQsrq() {
        return qsrq;
    }


    public void setQsrq(Date qsrq) {
        this.qsrq = qsrq;
    }

    public Date getZzrq() {
        return zzrq;
    }

    public void setZzrq(Date zzrq) {
        this.zzrq = zzrq;
    }

    public String getFwbm() {
        return fwbm;
    }

    public void setFwbm(String fwbm) {
        this.fwbm = fwbm;
    }

    public Integer getFwcs() {
        return fwcs;
    }

    public void setFwcs(Integer fwcs) {
        this.fwcs = fwcs;
    }

    public Date getJgrq() {
        return jgrq;
    }

    public void setJgrq(Date jgrq) {
        this.jgrq = jgrq;
    }

    public String getZzdmj() {
        return zzdmj;
    }

    public void setZzdmj(String zzdmj) {
        this.zzdmj = zzdmj;
    }

    public List<FwZhsDO> getFwZhsList() {
        return fwZhsList;
    }

    public void setFwZhsList(List<FwZhsDO> fwZhsList) {
        this.fwZhsList = fwZhsList;
    }

    public String getDjid() {
        return djid;
    }

    public void setDjid(String djid) {
        this.djid = djid;
    }

    public String getFwDcbIndex() {
        return fwDcbIndex;
    }

    public void setFwDcbIndex(String fwDcbIndex) {
        this.fwDcbIndex = fwDcbIndex;
    }

    public String getLszd() {
        return lszd;
    }

    public void setLszd(String lszd) {
        this.lszd = lszd;
    }

    public String getZrzh() {
        return zrzh;
    }

    public void setZrzh(String zrzh) {
        this.zrzh = zrzh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public Integer getWlcs() {
        return wlcs;
    }

    public void setWlcs(Integer wlcs) {
        this.wlcs = wlcs;
    }

    public String getFjh() {
        return fjh;
    }

    public void setFjh(String fjh) {
        this.fjh = fjh;
    }

    public String getDycs() {
        return dycs;
    }

    public void setDycs(String dycs) {
        this.dycs = dycs;
    }

    public String getDyh() {
        return dyh;
    }

    public void setDyh(String dyh) {
        this.dyh = dyh;
    }

    public Integer getSxh() {
        return sxh;
    }

    public void setSxh(Integer sxh) {
        this.sxh = sxh;
    }

    public Integer getCh() {
        return ch;
    }

    public void setCh(Integer ch) {
        this.ch = ch;
    }

    public Double getCg() {
        return cg;
    }

    public void setCg(Double cg) {
        this.cg = cg;
    }

    public Double getGytdmj() {
        return gytdmj;
    }

    public void setGytdmj(Double gytdmj) {
        this.gytdmj = gytdmj;
    }

    public Double getFttdmj() {
        return fttdmj;
    }

    public void setFttdmj(Double fttdmj) {
        this.fttdmj = fttdmj;
    }

    public Double getDytdmj() {
        return dytdmj;
    }

    public void setDytdmj(Double dytdmj) {
        this.dytdmj = dytdmj;
    }

    public Double getYcjzmj() {
        return ycjzmj;
    }

    public void setYcjzmj(Double ycjzmj) {
        this.ycjzmj = ycjzmj;
    }

    public Double getYctnjzmj() {
        return yctnjzmj;
    }

    public void setYctnjzmj(Double yctnjzmj) {
        this.yctnjzmj = yctnjzmj;
    }

    public Double getYcftjzmj() {
        return ycftjzmj;
    }

    public void setYcftjzmj(Double ycftjzmj) {
        this.ycftjzmj = ycftjzmj;
    }

    public Double getYcdxbfjzmj() {
        return ycdxbfjzmj;
    }

    public void setYcdxbfjzmj(Double ycdxbfjzmj) {
        this.ycdxbfjzmj = ycdxbfjzmj;
    }

    public Double getYcqtjzmj() {
        return ycqtjzmj;
    }

    public void setYcqtjzmj(Double ycqtjzmj) {
        this.ycqtjzmj = ycqtjzmj;
    }

    public Double getYcftxs() {
        return ycftxs;
    }

    public void setYcftxs(Double ycftxs) {
        this.ycftxs = ycftxs;
    }

    public Double getScjzmj() {
        return scjzmj;
    }

    public void setScjzmj(Double scjzmj) {
        this.scjzmj = scjzmj;
    }

    public Double getSctnjzmj() {
        return sctnjzmj;
    }

    public void setSctnjzmj(Double sctnjzmj) {
        this.sctnjzmj = sctnjzmj;
    }

    public Double getScftjzmj() {
        return scftjzmj;
    }

    public void setScftjzmj(Double scftjzmj) {
        this.scftjzmj = scftjzmj;
    }

    public Double getScdxbfjzmj() {
        return scdxbfjzmj;
    }

    public void setScdxbfjzmj(Double scdxbfjzmj) {
        this.scdxbfjzmj = scdxbfjzmj;
    }

    public Double getScqtjzmj() {
        return scqtjzmj;
    }

    public void setScqtjzmj(Double scqtjzmj) {
        this.scqtjzmj = scqtjzmj;
    }

    public Double getScftxs() {
        return scftxs;
    }

    public void setScftxs(Double scftxs) {
        this.scftxs = scftxs;
    }

    public Double getJyjg() {
        return jyjg;
    }

    public void setJyjg(Double jyjg) {
        this.jyjg = jyjg;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getGhyt() {
        return ghyt;
    }

    public void setGhyt(String ghyt) {
        this.ghyt = ghyt;
    }

    public String getGhyt2() {
        return ghyt2;
    }

    public void setGhyt2(String ghyt2) {
        this.ghyt2 = ghyt2;
    }

    public String getGhyt3() {
        return ghyt3;
    }

    public void setGhyt3(String ghyt3) {
        this.ghyt3 = ghyt3;
    }

    public String getFwlx() {
        return fwlx;
    }

    public void setFwlx(String fwlx) {
        this.fwlx = fwlx;
    }

    public String getFwxz() {
        return fwxz;
    }

    public void setFwxz(String fwxz) {
        this.fwxz = fwxz;
    }

    public String getCqly() {
        return cqly;
    }

    public void setCqly(String cqly) {
        this.cqly = cqly;
    }

    public String getHxjg() {
        return hxjg;
    }

    public void setHxjg(String hxjg) {
        this.hxjg = hxjg;
    }

    public String getFcdah() {
        return fcdah;
    }

    public void setFcdah(String fcdah) {
        this.fcdah = fcdah;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public String getQlzt() {
        return qlzt;
    }

    public void setQlzt(String qlzt) {
        this.qlzt = qlzt;
    }

    public String getBdczt() {
        return bdczt;
    }

    public void setBdczt(String bdczt) {
        this.bdczt = bdczt;
    }

    public List<FwLjzDO> getLjzList() {
        return ljzList;
    }

    public void setLjzList(List<FwLjzDO> ljzList) {
        this.ljzList = ljzList;
    }

    public String getXmmc() {
        return xmmc;
    }

    public void setXmmc(String xmmc) {
        this.xmmc = xmmc;
    }

    public List<FwFcqlrDO> getQlrList() {
        return qlrList;
    }

    public void setQlrList(List<FwFcqlrDO> qlrList) {
        this.qlrList = qlrList;
    }

    public Integer getZts() {
        return zts;
    }

    public void setZts(Integer zts) {
        this.zts = zts;
    }

    public String getBdcdyfwlx() {
        return bdcdyfwlx;
    }

    public void setBdcdyfwlx(String bdcdyfwlx) {
        this.bdcdyfwlx = bdcdyfwlx;
    }

    public String getHslx() {
        return hslx;
    }

    public void setHslx(String hslx) {
        this.hslx = hslx;
    }

    public String getDh() {
        return dh;
    }

    public void setDh(String dh) {
        this.dh = dh;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public String getFwjg() {
        return fwjg;
    }

    public void setFwjg(String fwjg) {
        this.fwjg = fwjg;
    }

    public Integer getDscs() {
        return dscs;
    }

    public void setDscs(Integer dscs) {
        this.dscs = dscs;
    }

    public String getTdsyqlx() {
        return tdsyqlx;
    }

    public void setTdsyqlx(String tdsyqlx) {
        this.tdsyqlx = tdsyqlx;
    }

    public String getYsxkzh() {
        return ysxkzh;
    }

    public void setYsxkzh(String ysxkzh) {
        this.ysxkzh = ysxkzh;
    }

    public String getGhxkzh() {
        return ghxkzh;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("BdcdyResponseDTO{");
        sb.append("hslx='").append(hslx).append('\'');
        sb.append(", djid='").append(djid).append('\'');
        sb.append(", fwDcbIndex='").append(fwDcbIndex).append('\'');
        sb.append(", bdcdyfwlx='").append(bdcdyfwlx).append('\'');
        sb.append(", lszd='").append(lszd).append('\'');
        sb.append(", zrzh='").append(zrzh).append('\'');
        sb.append(", dh='").append(dh).append('\'');
        sb.append(", bdcdyh='").append(bdcdyh).append('\'');
        sb.append(", xmmc='").append(xmmc).append('\'');
        sb.append(", wlcs=").append(wlcs);
        sb.append(", fjh='").append(fjh).append('\'');
        sb.append(", dycs='").append(dycs).append('\'');
        sb.append(", dyh='").append(dyh).append('\'');
        sb.append(", sxh=").append(sxh);
        sb.append(", ch=").append(ch);
        sb.append(", cg=").append(cg);
        sb.append(", gytdmj=").append(gytdmj);
        sb.append(", fttdmj=").append(fttdmj);
        sb.append(", dytdmj=").append(dytdmj);
        sb.append(", ycjzmj=").append(ycjzmj);
        sb.append(", yctnjzmj=").append(yctnjzmj);
        sb.append(", ycftjzmj=").append(ycftjzmj);
        sb.append(", ycdxbfjzmj=").append(ycdxbfjzmj);
        sb.append(", ycqtjzmj=").append(ycqtjzmj);
        sb.append(", ycftxs=").append(ycftxs);
        sb.append(", scjzmj=").append(scjzmj);
        sb.append(", sctnjzmj=").append(sctnjzmj);
        sb.append(", scftjzmj=").append(scftjzmj);
        sb.append(", scdxbfjzmj=").append(scdxbfjzmj);
        sb.append(", scqtjzmj=").append(scqtjzmj);
        sb.append(", scftxs=").append(scftxs);
        sb.append(", jyjg=").append(jyjg);
        sb.append(", zl='").append(zl).append('\'');
        sb.append(", ghyt='").append(ghyt).append('\'');
        sb.append(", ghyt2='").append(ghyt2).append('\'');
        sb.append(", ghyt3='").append(ghyt3).append('\'');
        sb.append(", fwlx='").append(fwlx).append('\'');
        sb.append(", fwxz='").append(fwxz).append('\'');
        sb.append(", cqly='").append(cqly).append('\'');
        sb.append(", hxjg='").append(hxjg).append('\'');
        sb.append(", fcdah='").append(fcdah).append('\'');
        sb.append(", gyqk='").append(gyqk).append('\'');
        sb.append(", qlzt='").append(qlzt).append('\'');
        sb.append(", bdczt='").append(bdczt).append('\'');
        sb.append(", ljzList=").append(ljzList);
        sb.append(", qlrList=").append(qlrList);
        sb.append(", fwZhsList=").append(fwZhsList);
        sb.append(", fwbm='").append(fwbm).append('\'');
        sb.append(", fwcs=").append(fwcs);
        sb.append(", jgrq=").append(jgrq);
        sb.append(", zzdmj='").append(zzdmj).append('\'');
        sb.append(", zts=").append(zts);
        sb.append(", qsrq=").append(qsrq);
        sb.append(", zzrq=").append(zzrq);
        sb.append(", fjsm='").append(fjsm).append('\'');
        sb.append(", dcyj='").append(dcyj).append('\'');
        sb.append(", dcz='").append(dcz).append('\'');
        sb.append(", dcsj=").append(dcsj);
        sb.append(", tdyt='").append(tdyt).append('\'');
        sb.append(", fwjg='").append(fwjg).append('\'');
        sb.append(", ysfwbm='").append(ysfwbm).append('\'');
        sb.append(", dscs=").append(dscs);
        sb.append(", tdsyqlx='").append(tdsyqlx).append('\'');
        sb.append(", ysxkzh='").append(ysxkzh).append('\'');
        sb.append(", ghxkzh='").append(ghxkzh).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public void setGhxkzh(String ghxkzh) {
        this.ghxkzh = ghxkzh;
    }
}
