package cn.gtmap.realestate.common.core.dto.accept;

import cn.gtmap.realestate.common.core.domain.BdcQlrDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlFwxxDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlJyxxDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlSqrDO;
import cn.gtmap.realestate.common.core.domain.accept.BdcSlXmDO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
 * @version 1.0, 2019/8/2
 * @description 房产交易备案信息（调用fcjybaxxbycqzhandzjh返回结果)
 */
@ApiModel(value = "FcjyBaxxDTO", description = "房产交易备案信息")
public class FcjyBaxxDTO {

    @ApiModelProperty(value = "响应信息")
    private String msg;

    @ApiModelProperty(value = "不动产受理交易信息")
    private BdcSlJyxxDO bdcSlJyxx;

    @ApiModelProperty(value = "响应码")
    private String code;

    @ApiModelProperty(value = "不动产权利人")
    private List<BdcQlrDO> bdcQlr;

    @ApiModelProperty(value = "不动产受理申请人")
    private List<BdcSlSqrDO> bdcSlSqr;

    @ApiModelProperty(value = "不动产受理房屋信息")
    private BdcSlFwxxDO bdcSlFwxx;

    @ApiModelProperty(value = "不动产受理项目信息")
    private BdcSlXmDO bdcSlXmDO;

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public BdcSlJyxxDO getBdcSlJyxx() {
        return bdcSlJyxx;
    }

    public void setBdcSlJyxx(BdcSlJyxxDO bdcSlJyxx) {
        this.bdcSlJyxx = bdcSlJyxx;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<BdcQlrDO> getBdcQlr() {
        return bdcQlr;
    }

    public void setBdcQlr(List<BdcQlrDO> bdcQlr) {
        this.bdcQlr = bdcQlr;
    }

    public List<BdcSlSqrDO> getBdcSlSqr() {
        return bdcSlSqr;
    }

    public void setBdcSlSqr(List<BdcSlSqrDO> bdcSlSqr) {
        this.bdcSlSqr = bdcSlSqr;
    }

    public BdcSlFwxxDO getBdcSlFwxx() {
        return bdcSlFwxx;
    }

    public void setBdcSlFwxx(BdcSlFwxxDO bdcSlFwxx) {
        this.bdcSlFwxx = bdcSlFwxx;
    }

    @Override
    public String toString() {
        return "FcjyBaxxDTO{" +
                "msg='" + msg + '\'' +
                ", bdcSlJyxx=" + bdcSlJyxx +
                ", code='" + code + '\'' +
                ", bdcQlr=" + bdcQlr +
                ", bdcSlSqr=" + bdcSlSqr +
                '}';
    }

    public BdcSlXmDO getBdcSlXmDO() {
        return bdcSlXmDO;
    }

    public void setBdcSlXmDO(BdcSlXmDO bdcSlXmDO) {
        this.bdcSlXmDO = bdcSlXmDO;
    }
}
