package cn.gtmap.realestate.common.core.dto.accept;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @program: realestate
 * @description: 打印传参DTO
 * @author: <a href="mailto:gaolining@gtmap.cn">gaolining</a>
 * @create: 2019-07-12 11:03
 **/
@ApiModel(value = "BdcSlPrintDTO", description = "打印传参DTO")
public class BdcSlPrintDTO implements Serializable {

    private static final long serialVersionUID = 5196308220346989454L;
    @ApiModelProperty(value = "打印地址")
    private String url;
    @ApiModelProperty(value = "项目id")
    private String xmid;
    @ApiModelProperty(value = "工作流实例id")
    private String gzlslid;
    @ApiModelProperty(value = "打印类型")
    private String dylx;
    @ApiModelProperty(value = "是否注销流程")
    private String zxlc;
    @ApiModelProperty(value = "权利人类别")
    private String qlrlb;
    @ApiModelProperty(value = "签字人类别类别")
    private String qzrlb;
    @ApiModelProperty(value = "收件材料id数组")
    private List<String> sjclids;

    @ApiModelProperty(value = "项目id数组")
    private List<String> xmids;

    @ApiModelProperty(value = "系统版本")
    private String systemVersion;

    public String getSystemVersion() {
        return systemVersion;
    }

    public void setSystemVersion(String systemVersion) {
        this.systemVersion = systemVersion;
    }

    public String getDyzl() {
        return dyzl;
    }

    public void setDyzl(String dyzl) {
        this.dyzl = dyzl;
    }

    @ApiModelProperty(value = "打印种类-pdf/fr3")
    private String dyzl;

    public List<String> getXmids() {
        return xmids;
    }

    public void setXmids(List<String> xmids) {
        this.xmids = xmids;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getXmid() {
        return xmid;
    }

    public void setXmid(String xmid) {
        this.xmid = xmid;
    }

    public String getGzlslid() {
        return gzlslid;
    }

    public void setGzlslid(String gzlslid) {
        this.gzlslid = gzlslid;
    }

    public String getZxlc() {
        return zxlc;
    }

    public void setZxlc(String zxlc) {
        this.zxlc = zxlc;
    }

    public List<String> getSjclids() {
        return sjclids;
    }

    public void setSjclids(List<String> sjclids) {
        this.sjclids = sjclids;
    }

    public String getQzrlb() {
        return qzrlb;
    }

    public void setQzrlb(String qzrlb) {
        this.qzrlb = qzrlb;
    }

    @Override
    public String toString() {
        return "BdcSlPrintDTO{" +
                "url='" + url + '\'' +
                ", xmid='" + xmid + '\'' +
                ", gzlslid='" + gzlslid + '\'' +
                ", dylx='" + dylx + '\'' +
                ", zxlc='" + zxlc + '\'' +
                ", qlrlb='" + qlrlb + '\'' +
                ", qzrlb='" + qzrlb + '\'' +
                ", sjclids=" + sjclids +
                ", xmids=" + xmids +
                ", systemVersion='" + systemVersion + '\'' +
                ", dyzl='" + dyzl + '\'' +
                '}';
    }

    public String getDylx() {
        return dylx;
    }

    public void setDylx(String dylx) {
        this.dylx = dylx;
    }

    public String getQlrlb() {
        return qlrlb;
    }

    public void setQlrlb(String qlrlb) {
        this.qlrlb = qlrlb;
    }
}
