package cn.gtmap.realestate.common.core.domain.building;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author <a href="mailto:wangzijie@gtmap.cn">wangzijie</a>
 * @version 1.0  2018/11/8
 * @description
 */
@Table(name = "lq_dcb")
@ApiModel(value = "LqDcbDO", description = "林权调查表信息实体")
public class LqDcbDO{

    /**
     * 林权调查表主键
     */
    @Id
    @ApiModelProperty(value = "林权调查表主键")
    private String lqDcbIndex;
    /**
     * 宗地调查表主键
     */
    @ApiModelProperty(value = "宗地调查表主键")
    private String zddcbIndex;
    /**
     * 地籍号
     */
    @ApiModelProperty(value = "地籍号")
    private String djh;
    /**
     * 不动产单元号
     */
    @ApiModelProperty(value = "不动产单元号")
    private String bdcdyh;
    /**
     * 小地名
     */
    @ApiModelProperty(value = "小地名")
    private String xdm;
    /**
     * 坐落
     */
    @ApiModelProperty(value = "坐落")
    private String zl;
    /**
     * 林班
     */
    @ApiModelProperty(value = "林班")
    private String lb;
    /**
     * 小班
     */
    @ApiModelProperty(value = "小班")
    private String xb;
    /**
     * 面积单位
     */
    @ApiModelProperty(value = "面积单位")
    private String mjdw;
    /**
     * 面积
     */
    @ApiModelProperty(value = "面积")
    private Double mj;
    /**
     * 株树
     */
    @ApiModelProperty(value = "株树")
    private Integer zs;
    /**
     * 林种
     */
    @ApiModelProperty(value = "林种")
    private String lz;
    /**
     * 主要树种
     */
    @ApiModelProperty(value = "主要树种")
    private String zysz;
    /**
     * 造林年份
     */
    @ApiModelProperty(value = "造林年份")
    private Integer zlnd;
    /**
     * 共有情况
     */
    @ApiModelProperty(value = "共有情况")
    private String gyqk;
    /**
     * 起源
     */
    @ApiModelProperty(value = "起源")
    private String qy;
    /**
     * 附记
     */
    @ApiModelProperty(value = "附记")
    private String fj;
    /**
     * 调查人员
     */
    @ApiModelProperty(value = "调查人员")
    private String dcry;
    /**
     * 调查日期
     */
    @ApiModelProperty(value = "调查日期",example = "2018-10-01 12:18:21")
    private Date dcrq;
    /**
     * 建立日期
     */
    @ApiModelProperty(value = "建立日期",example = "2018-10-01 12:18:21")
    private Date jlrq;
    /**
     * 更新日期
     */
    @ApiModelProperty(value = "更新日期",example = "2018-10-01 12:18:21")
    private Date gxrq;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String bz;


    public String getLqDcbIndex() {
        return lqDcbIndex;
    }

    public void setLqDcbIndex(String lqDcbIndex) {
        this.lqDcbIndex = lqDcbIndex;
    }

    public String getZddcbIndex() {
        return zddcbIndex;
    }

    public void setZddcbIndex(String zddcbIndex) {
        this.zddcbIndex = zddcbIndex;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getBdcdyh() {
        return bdcdyh;
    }

    public void setBdcdyh(String bdcdyh) {
        this.bdcdyh = bdcdyh;
    }

    public String getXdm() {
        return xdm;
    }

    public void setXdm(String xdm) {
        this.xdm = xdm;
    }

    public String getZl() {
        return zl;
    }

    public void setZl(String zl) {
        this.zl = zl;
    }

    public String getLb() {
        return lb;
    }

    public void setLb(String lb) {
        this.lb = lb;
    }

    public String getXb() {
        return xb;
    }

    public void setXb(String xb) {
        this.xb = xb;
    }

    public String getMjdw() {
        return mjdw;
    }

    public void setMjdw(String mjdw) {
        this.mjdw = mjdw;
    }

    public Double getMj() {
        return mj;
    }

    public void setMj(Double mj) {
        this.mj = mj;
    }

    public Integer getZs() {
        return zs;
    }

    public void setZs(Integer zs) {
        this.zs = zs;
    }

    public String getLz() {
        return lz;
    }

    public void setLz(String lz) {
        this.lz = lz;
    }

    public String getZysz() {
        return zysz;
    }

    public void setZysz(String zysz) {
        this.zysz = zysz;
    }

    public Integer getZlnd() {
        return zlnd;
    }

    public void setZlnd(Integer zlnd) {
        this.zlnd = zlnd;
    }

    public String getGyqk() {
        return gyqk;
    }

    public void setGyqk(String gyqk) {
        this.gyqk = gyqk;
    }

    public String getQy() {
        return qy;
    }

    public void setQy(String qy) {
        this.qy = qy;
    }

    public String getFj() {
        return fj;
    }

    public void setFj(String fj) {
        this.fj = fj;
    }

    public String getDcry() {
        return dcry;
    }

    public void setDcry(String dcry) {
        this.dcry = dcry;
    }

    public Date getDcrq() {
        return dcrq;
    }

    public void setDcrq(Date dcrq) {
        this.dcrq = dcrq;
    }

    public Date getJlrq() {
        return jlrq;
    }

    public void setJlrq(Date jlrq) {
        this.jlrq = jlrq;
    }

    public Date getGxrq() {
        return gxrq;
    }

    public void setGxrq(Date gxrq) {
        this.gxrq = gxrq;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("LqDcbDO{");
        sb.append("lqDcbIndex='").append(lqDcbIndex).append('\'');
        sb.append(", zddcbIndex='").append(zddcbIndex).append('\'');
        sb.append(", djh='").append(djh).append('\'');
        sb.append(", bdcdyh='").append(bdcdyh).append('\'');
        sb.append(", xdm='").append(xdm).append('\'');
        sb.append(", zl='").append(zl).append('\'');
        sb.append(", lb='").append(lb).append('\'');
        sb.append(", xb='").append(xb).append('\'');
        sb.append(", mjdw='").append(mjdw).append('\'');
        sb.append(", mj=").append(mj);
        sb.append(", zs=").append(zs);
        sb.append(", lz='").append(lz).append('\'');
        sb.append(", zysz='").append(zysz).append('\'');
        sb.append(", zlnd=").append(zlnd);
        sb.append(", gyqk='").append(gyqk).append('\'');
        sb.append(", qy='").append(qy).append('\'');
        sb.append(", fj='").append(fj).append('\'');
        sb.append(", dcry='").append(dcry).append('\'');
        sb.append(", dcrq=").append(dcrq);
        sb.append(", jlrq=").append(jlrq);
        sb.append(", gxrq=").append(gxrq);
        sb.append(", bz='").append(bz).append('\'');
        sb.append('}');
        return sb.toString();
    }
}